/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenTeleskopeDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.category.DefaultCategoryDataset;

public final class DiscovererTelescopesAndStatistics
implements IChart {
    private final ISprachcontainer sprache;
    private final IPlanetenTeleskopeDAO planetenDAO;
    private DefaultCategoryDataset dataset;

    @Inject
    public DiscovererTelescopesAndStatistics(IChartRepository iChartRepository, IPlanetenTeleskopeDAO iPlanetenTeleskopeDAO) {
        this.planetenDAO = iPlanetenTeleskopeDAO;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        Map<String, Integer> map = this.planetenDAO.getTeleskopeUndProzentPlaneten();
        this.addData("sim_gui171", map);
        Map<String, Integer> map2 = this.planetenDAO.getTeleskopeInMehrfachsternsystemenUndProzentPlaneten();
        this.addData("sim_gui172", map2);
        Map<String, Integer> map3 = this.planetenDAO.getTeleskopeUndProzentEntferntestePlaneten();
        this.addData("sim_gui173", map3);
        Map<String, Integer> map4 = this.planetenDAO.getTeleskopeUndProzentKleinePlaneten();
        this.addData("sim_gui174", map4);
        Map<String, Integer> map5 = this.planetenDAO.getTeleskopeUndProzentLanglaufendePlaneten();
        this.addData("sim_gui175", map5);
    }

    private void addData(String string, Map<String, Integer> map) {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            this.dataset.addValue(entry.getValue(), (Comparable)((Object)this.sprache.getString("ps_" + entry.getKey())), (Comparable)((Object)this.sprache.getString(string)));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.getChartName(), this.sprache.getString("sim_gui177"), this.sprache.getString("sim_gui170"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        GroupedStackedBarRenderer groupedStackedBarRenderer = new GroupedStackedBarRenderer();
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap();
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)this.sprache.getString("sim_gui178")), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)this.sprache.getString("sim_gui179")), (Comparable)((Object)"G1"));
        groupedStackedBarRenderer.setSeriesToGroupMap(keyToGroupMap);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setRenderer(groupedStackedBarRenderer);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui176");
    }

    @Override
    public String getChartKey() {
        return "sim_gui176";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_TELESKOPE_STATISTIK;
    }
}

