/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.IEntdeckungsdatumDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class DiscoveryYearAndMassChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IEntdeckungsdatumDAO entdeckungsdatumDAO;
    private XYSeriesCollection collection;

    @Inject
    public DiscoveryYearAndMassChart(IChartRepository iChartRepository, IEntdeckungsdatumDAO iEntdeckungsdatumDAO) {
        this.entdeckungsdatumDAO = iEntdeckungsdatumDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        HashMap<Integer, List<Double>> hashMap = new HashMap<Integer, List<Double>>();
        int n = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        for (int i = 1989; i <= gregorianCalendar.get(1); ++i) {
            List<Double> list = this.entdeckungsdatumDAO.getValuesForDiscoveryYearAndColumn(i, QDaten.daten.masse, 30.0, true);
            hashMap.put(i, list);
            n += list.size();
        }
        XYSeries xYSeries = new XYSeries((Comparable)((Object)(this.i18n.getString("sim_gui110") + " (" + this.i18n.toLocalisedInt(n) + ")")));
        for (Map.Entry entry : hashMap.entrySet()) {
            List list = (List)entry.getValue();
            for (Double d : list) {
                xYSeries.add((Number)entry.getKey(), (Number)d);
            }
        }
        this.collection.addSeries(xYSeries);
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.i18n.getString("sim_gui12"), this.i18n.getString("sim_m76"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui15");
    }

    @Override
    public String getChartKey() {
        return "sim_gui15";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_ENTDECKUNGSJAHR_MASSE;
    }
}

