/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.planeten.IEntdeckungsjahrRepository;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class DiscoveryYearAndPersons
implements IChart {
    private static final int FIRST_EXOPLANET_YEAR = 1989;
    private final ISprachcontainer i18n;
    private final IEntdeckungsjahrRepository entdeckungsjahrRepository;
    private DefaultCategoryDataset dataset;
    private int startJahr;
    private int aktuellesJahr;
    private String titel;

    @Inject
    public DiscoveryYearAndPersons(IChartRepository iChartRepository, IEntdeckungsjahrRepository iEntdeckungsjahrRepository) {
        this.entdeckungsjahrRepository = iEntdeckungsjahrRepository;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    private void waehleStartEntdeckungsjahr() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.aktuellesJahr = gregorianCalendar.get(1);
        Object[] objectArray = new Object[this.aktuellesJahr - 1989];
        int n = 0;
        for (int i = 1989; i < this.aktuellesJahr; ++i) {
            objectArray[n] = i;
            ++n;
        }
        Object object = JOptionPane.showInputDialog(null, this.i18n.getString("sim_m145"), this.i18n.getString("um_gui1"), 3, null, objectArray, this.startJahr);
        this.startJahr = object != null ? Integer.parseInt(object.toString()) : 1989;
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(this.titel, this.i18n.getString("sim_gui12"), this.i18n.getString("sim_gui195"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return new ChartPanel(jFreeChart);
    }

    @Override
    public void beforeCollectData() {
        this.waehleStartEntdeckungsjahr();
    }

    @Override
    public String getChartName() {
        String string = this.i18n.getString("sim_m151");
        return string;
    }

    @Override
    public String getChartKey() {
        String string = "sim_m151";
        return string;
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public void collectData() throws SQLException {
        int n = 0;
        this.dataset = new DefaultCategoryDataset();
        for (int i = this.startJahr; i <= this.aktuellesJahr; ++i) {
            Map<String, Integer> map = this.entdeckungsjahrRepository.getEntdeckerUndAnzahl(i);
            Set<Map.Entry<String, Integer>> set = map.entrySet();
            Iterator<Map.Entry<String, Integer>> iterator = set.iterator();
            for (int j = 0; j < 3; ++j) {
                if (!iterator.hasNext()) continue;
                Map.Entry<String, Integer> entry = iterator.next();
                String string = entry.getKey();
                Integer n2 = entry.getValue();
                this.dataset.addValue(n2, (Comparable)((Object)string), (Comparable)((Object)Integer.toString(i)));
                n += n2.intValue();
            }
        }
        this.titel = this.i18n.toLocalisedInt(n) + " " + this.i18n.getString("sim_gui110") + " (" + this.startJahr + "-" + this.aktuellesJahr + ")";
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_ENTDECKUNGSJAHR_PERSONEN;
    }
}

