/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.repos.IEntdeckerRepository;
import de.planetensuche.datenbankkern.querydsl5.Entdecker;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.planeten.IEntdeckungsjahrRepository;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class DiscoveryYearAndProjects
implements IChart {
    private static final int FIRST_EXOPLANET_YEAR = 1989;
    private final ISprachcontainer i18n;
    private final IEntdeckungsjahrRepository entdeckungsjahrRepository;
    private DefaultCategoryDataset dataset;
    private List<Entdecker> entdeckerteams;
    private int startJahr;
    private int aktuellesJahr;
    private String titel;
    private final IEntdeckerRepository entdeckerRepository;

    @Inject
    public DiscoveryYearAndProjects(IChartRepository iChartRepository, IEntdeckungsjahrRepository iEntdeckungsjahrRepository, IEntdeckerRepository iEntdeckerRepository) {
        this.entdeckungsjahrRepository = iEntdeckungsjahrRepository;
        this.entdeckerRepository = iEntdeckerRepository;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    private void waehleStartEntdeckungsjahr() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.aktuellesJahr = gregorianCalendar.get(1);
        Object[] objectArray = new Object[this.aktuellesJahr - 1989];
        int n = 0;
        for (int i = 1989; i < this.aktuellesJahr; ++i) {
            objectArray[n] = i;
            ++n;
        }
        Object object = JOptionPane.showInputDialog(null, this.i18n.getString("sim_m145"), this.i18n.getString("um_gui1"), 3, null, objectArray, this.startJahr);
        this.startJahr = object != null ? Integer.parseInt(object.toString()) : 1989;
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.titel, this.i18n.getString("sim_gui12"), this.i18n.getString("sim_gui195"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return new ChartPanel(jFreeChart);
    }

    @Override
    public void beforeCollectData() {
        this.waehleStartEntdeckungsjahr();
    }

    @Override
    public String getChartName() {
        String string = this.i18n.getString("sim_m152");
        return string;
    }

    @Override
    public String getChartKey() {
        String string = "sim_m152";
        return string;
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public void collectData() throws SQLException {
        int n = 0;
        this.dataset = new DefaultCategoryDataset();
        for (int i = this.startJahr; i <= this.aktuellesJahr; ++i) {
            n += this.getAnzahlEntdeckerteam(i);
        }
        this.titel = this.i18n.toLocalisedInt(n) + " " + this.i18n.getString("sim_gui110") + " (" + this.startJahr + "-" + this.aktuellesJahr + ")";
    }

    private int getAnzahlEntdeckerteam(int n) throws SQLException {
        if (this.entdeckerteams == null) {
            this.entdeckerteams = this.entdeckerRepository.findAllDiscovererTeams();
        }
        Map<String, Integer> map = this.entdeckungsjahrRepository.getEntdeckerUndAnzahl(this.entdeckerteams, n);
        int n2 = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            this.dataset.addValue(entry.getValue(), (Comparable)((Object)entry.getKey()), (Comparable)((Object)Integer.toString(n)));
            n2 += entry.getValue().intValue();
        }
        return n2;
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_ENTDECKUNGSJAHR_PROJEKTE;
    }
}

