/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.simulationen.diagramme.PlanetennamenAuswaehlerUtil;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class EarthSimilarityIndexChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IPlanetenDAO planetenDAO;
    private final IObjektnamenRepository objektnamenRepository;
    private XYSeriesCollection collection;
    private String chartName;

    @Inject
    public EarthSimilarityIndexChart(IChartRepository iChartRepository, IPlanetenDAO iPlanetenDAO, IObjektnamenRepository iObjektnamenRepository) {
        this.planetenDAO = iPlanetenDAO;
        this.objektnamenRepository = iObjektnamenRepository;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.chartName = this.i18n.getString("sim_gui214");
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        List<ErgebnisXYDto> list = this.planetenDAO.getEsiAndDistanceInLy();
        this.collection = new XYSeriesCollection();
        this.chartName = this.chartName + " (" + list.size() + " " + this.i18n.getString("ps_planeten") + ")";
        PlanetennamenAuswaehlerUtil planetennamenAuswaehlerUtil = new PlanetennamenAuswaehlerUtil();
        for (ErgebnisXYDto ergebnisXYDto : list) {
            List<String> list2 = this.objektnamenRepository.getNamenByDatenId(ergebnisXYDto.getId(), ObjektnamenSortierung.BEKANNTHEIT);
            XYSeries xYSeries = new XYSeries((Comparable)((Object)planetennamenAuswaehlerUtil.getBekannterName(list2)));
            xYSeries.add(ergebnisXYDto.getX(), ergebnisXYDto.getY());
            this.collection.addSeries(xYSeries);
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.i18n.getString("sim_gui215"), this.i18n.getString("sim_gui216"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.chartName;
    }

    @Override
    public String getChartKey() {
        return "sim_gui214";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_ESI;
    }
}

