/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.planeten.IEntdeckungsjahrRepository;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DatasetUtils;

public final class Entdeckungsjahr
implements IChart {
    private static final int FIRST_EXOPLANET_YEAR = 1989;
    private final ISprachcontainer i18n;
    private final IEntdeckungsjahrRepository entdeckungsjahrRepository;
    private DefaultCategoryDataset dataset;
    private DefaultKeyedValues dataForKumulativView;
    private List<String> entdeckungsmethoden;
    private boolean showEntdeckungsmethoden;
    private boolean showEntdeckungenProJahr;
    private int startJahr;
    private int aktuellesJahr;
    private String titel;

    @Inject
    public Entdeckungsjahr(IChartRepository iChartRepository, IEntdeckungsjahrRepository iEntdeckungsjahrRepository) {
        this.entdeckungsjahrRepository = iEntdeckungsjahrRepository;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(new Entdeckungsjahr(iEntdeckungsjahrRepository, true, false));
        iChartRepository.register(new Entdeckungsjahr(iEntdeckungsjahrRepository, false, true));
    }

    public Entdeckungsjahr(IEntdeckungsjahrRepository iEntdeckungsjahrRepository, boolean bl, boolean bl2) {
        this.entdeckungsjahrRepository = iEntdeckungsjahrRepository;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.showEntdeckungsmethoden = bl;
        this.showEntdeckungenProJahr = bl2;
    }

    private void waehleStartEntdeckungsjahr() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.aktuellesJahr = gregorianCalendar.get(1);
        Object[] objectArray = new Object[this.aktuellesJahr - 1989];
        int n = 0;
        for (int i = 1989; i < this.aktuellesJahr; ++i) {
            objectArray[n] = i;
            ++n;
        }
        Object object = JOptionPane.showInputDialog(null, this.i18n.getString("sim_m145"), this.i18n.getString("um_gui1"), 3, null, objectArray, this.startJahr);
        this.startJahr = object != null ? Integer.parseInt(object.toString()) : 1989;
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart;
        if (this.showEntdeckungenProJahr) {
            CategoryDataset categoryDataset = DatasetUtils.createCategoryDataset((Comparable)((Object)this.i18n.getString("sim_gui111")), this.dataForKumulativView);
            jFreeChart = ChartFactory.createBarChart(this.titel, this.i18n.getString("sim_gui12"), this.i18n.getString("sim_gui195"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
            CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
            NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
            numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
            categoryPlot.setDataset(1, categoryDataset);
            categoryPlot.setRenderer(1, lineAndShapeRenderer);
            categoryPlot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        } else {
            jFreeChart = ChartFactory.createBarChart(this.titel, this.i18n.getString("sim_gui12"), this.i18n.getString("sim_gui195"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
            CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
            NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
            numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        }
        return new ChartPanel(jFreeChart);
    }

    @Override
    public void beforeCollectData() {
        this.waehleStartEntdeckungsjahr();
    }

    @Override
    public String getChartName() {
        String string = null;
        if (this.showEntdeckungenProJahr) {
            string = this.i18n.getString("sim_gui12");
        } else if (this.showEntdeckungsmethoden) {
            string = this.i18n.getString("sim_gui137");
        }
        return string;
    }

    @Override
    public String getChartKey() {
        String string = null;
        if (this.showEntdeckungenProJahr) {
            string = "sim_gui12";
        } else if (this.showEntdeckungsmethoden) {
            string = "sim_gui137";
        }
        return string;
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public void collectData() throws SQLException {
        int n = 0;
        this.dataset = new DefaultCategoryDataset();
        this.dataForKumulativView = new DefaultKeyedValues();
        for (int i = this.startJahr; i <= this.aktuellesJahr; ++i) {
            if (this.showEntdeckungsmethoden) {
                n += this.getAnzahlEntdeckungsmethode(i);
                continue;
            }
            if (!this.showEntdeckungenProJahr) continue;
            int n2 = this.getAnzahlEntdeckungen(i);
            this.dataForKumulativView.addValue(Integer.toString(i), n += n2);
        }
        this.titel = this.i18n.toLocalisedInt(n) + " " + this.i18n.getString("sim_gui110") + " (" + this.startJahr + "-" + this.aktuellesJahr + ")";
    }

    private int getAnzahlEntdeckungen(int n) throws SQLException {
        int n2 = this.entdeckungsjahrRepository.countPlanetenProJahr(n);
        this.dataset.addValue(n2, (Comparable)((Object)this.i18n.getString("sim_gui110")), (Comparable)((Object)Integer.toString(n)));
        return n2;
    }

    private int getAnzahlEntdeckungsmethode(int n) throws SQLException {
        if (this.entdeckungsmethoden == null) {
            this.entdeckungsmethoden = this.entdeckungsjahrRepository.getAlleEntdeckungsmethoden();
        }
        int n2 = 0;
        for (String string : this.entdeckungsmethoden) {
            n2 += this.addEntdeckungsmethodeToDataset(n, string);
        }
        return n2;
    }

    private int addEntdeckungsmethodeToDataset(int n, String string) throws SQLException {
        int n2 = this.entdeckungsjahrRepository.countPlanetenNachMethode(n, string);
        if (n2 > 0) {
            String string2 = this.i18n.getUebersetzungFuerAktuelleSprache(string);
            this.dataset.addValue(n2, (Comparable)((Object)string2), (Comparable)((Object)Integer.toString(n)));
        }
        return n2;
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_ENTDECKUNGSJAHR;
    }
}

