/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeriesCollection;

public final class ExcentrityAndSemiMajorAxisChart
implements IChart {
    private final ISprachcontainer sprache;
    private final IPlanetenDAO planetenDAO;
    private final DiagrammHelfer helfer;
    private XYSeriesCollection collection;
    private double maxEntfernung;

    @Inject
    public ExcentrityAndSemiMajorAxisChart(IChartRepository iChartRepository, IPlanetenDAO iPlanetenDAO) {
        this.planetenDAO = iPlanetenDAO;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.sprache);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
        this.maxEntfernung = this.helfer.zeigeEingabeDialog(null, this.sprache.getString("sim_m13"), this.sprache.getString("ps_planeten"), 10.0, "AE", 0.5, new double[0]);
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        this.helfer.fuelleXYSeriesCollection(this.collection, this.sprache.getString("sim_m27"), this.planetenDAO.getExzentritaetUndBahnabstand(this.maxEntfernung, true));
        this.helfer.fuelleXYSeriesCollection(this.collection, this.sprache.getString("sim_gui110"), this.planetenDAO.getExzentritaetUndBahnabstand(this.maxEntfernung, false));
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("sim_m75"), this.sprache.getString("db_m111"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui23");
    }

    @Override
    public String getChartKey() {
        return "sim_gui23";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_EXZENTRITAET_APHEL;
    }
}

