/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class ExoplanetsAndDistanceChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IPlanetenDAO planetenDAO;
    private DiagrammHelfer helfer;
    private DefaultCategoryDataset dataset;
    private double maxEntfernung;

    @Inject
    public ExoplanetsAndDistanceChart(IChartRepository iChartRepository, IPlanetenDAO iPlanetenDAO) {
        this.planetenDAO = iPlanetenDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.i18n);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
        this.maxEntfernung = this.helfer.zeigeEingabeDialog(null, this.i18n.getString("sim_m9"), this.i18n.getString("sim_m10"), 1000.0, "ly", 5.0, new double[0]);
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        int n = (int)Math.round(this.maxEntfernung / 10.0);
        for (int i = 1; i < 11; ++i) {
            int n2 = this.planetenDAO.getAnzahlPlaneten((double)(n * i) * 1.0);
            this.dataset.addValue(n2, (Comparable)((Object)("<" + this.i18n.toLocalisedInt(n * i) + " ly")), (Comparable)((Object)""));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.getChartName(), this.i18n.getString("sim_m68"), this.i18n.getString("sim_gui195"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui21");
    }

    @Override
    public String getChartKey() {
        return "sim_gui21";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_ENTFERNUNG;
    }
}

