/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class ExoplanetsAndSptypesChart
implements IChart {
    private final ISprachcontainer i18n;
    private final ISterneDAO sterneDAO;
    private DefaultCategoryDataset dataset;
    private String title;

    @Inject
    public ExoplanetsAndSptypesChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO) {
        this.sterneDAO = iSterneDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        int n = this.sterneDAO.getAnzahlSpektraltypenMitPlaneten("O", true);
        int n2 = this.sterneDAO.getAnzahlSpektraltypenMitPlaneten("B", true);
        int n3 = this.sterneDAO.getAnzahlSpektraltypenMitPlaneten("A", true);
        int n4 = this.sterneDAO.getAnzahlSpektraltypenMitPlaneten("F", true);
        int n5 = this.sterneDAO.getAnzahlSpektraltypenMitPlaneten("G", true);
        int n6 = this.sterneDAO.getAnzahlSpektraltypenMitPlaneten("K", true);
        int n7 = this.sterneDAO.getAnzahlSpektraltypenMitPlaneten("M", true);
        int n8 = this.sterneDAO.getAnzahlSpektraltypenMitPlaneten("M", false);
        int n9 = this.sterneDAO.getAnzahlSpektraltypenMitPlaneten("L", false);
        int n10 = this.sterneDAO.getAnzahlSpektraltypenMitPlaneten("T", false);
        int n11 = this.sterneDAO.getAnzahlSpektraltypenMitPlaneten("Y", false);
        int n12 = n + n2 + n3 + n4 + n5 + n6 + n7 + n8 + n9 + n10 + n11;
        this.title = this.getChartName() + " (" + this.i18n.toLocalisedInt(n12) + " " + this.i18n.getString("db_kategorie_sterne") + " + " + this.i18n.getString("db_kategorie_braune_zwerge") + ")";
        this.dataset.addValue(n, (Comparable)((Object)("O " + this.getInPercent(n, n12))), (Comparable)((Object)this.i18n.getString("ps_sterne")));
        this.dataset.addValue(n2, (Comparable)((Object)("B " + this.getInPercent(n2, n12))), (Comparable)((Object)this.i18n.getString("ps_sterne")));
        this.dataset.addValue(n3, (Comparable)((Object)("A " + this.getInPercent(n3, n12))), (Comparable)((Object)this.i18n.getString("ps_sterne")));
        this.dataset.addValue(n4, (Comparable)((Object)("F " + this.getInPercent(n4, n12))), (Comparable)((Object)this.i18n.getString("ps_sterne")));
        this.dataset.addValue(n5, (Comparable)((Object)("G " + this.getInPercent(n5, n12))), (Comparable)((Object)this.i18n.getString("ps_sterne")));
        this.dataset.addValue(n6, (Comparable)((Object)("K " + this.getInPercent(n6, n12))), (Comparable)((Object)this.i18n.getString("ps_sterne")));
        this.dataset.addValue(n7, (Comparable)((Object)("M " + this.getInPercent(n7, n12))), (Comparable)((Object)this.i18n.getString("ps_sterne")));
        this.dataset.addValue(n8, (Comparable)((Object)(this.i18n.getString("ps_br_zwerge") + " M " + this.getInPercent(n8, n12))), (Comparable)((Object)this.i18n.getString("ps_br_zwerge")));
        this.dataset.addValue(n9, (Comparable)((Object)(this.i18n.getString("ps_br_zwerge") + " L " + this.getInPercent(n9, n12))), (Comparable)((Object)this.i18n.getString("ps_br_zwerge")));
        this.dataset.addValue(n10, (Comparable)((Object)(this.i18n.getString("ps_br_zwerge") + " T " + this.getInPercent(n10, n12))), (Comparable)((Object)this.i18n.getString("ps_br_zwerge")));
        this.dataset.addValue(n11, (Comparable)((Object)(this.i18n.getString("ps_br_zwerge") + " Y " + this.getInPercent(n11, n12))), (Comparable)((Object)this.i18n.getString("ps_br_zwerge")));
    }

    private String getInPercent(int n, int n2) {
        return this.i18n.toLocalisedDouble((double)Math.round((double)n * 10000.0 / (double)n2) / 100.0) + "%";
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.title, this.i18n.getString("sim_m57"), this.i18n.getString("sim_m48"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui19");
    }

    @Override
    public String getChartKey() {
        return "sim_gui19";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_SPTYPEN;
    }
}

