/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class ExoplanetsPerStarChart
implements IChart {
    private final ISprachcontainer sprache;
    private final IPlanetenDAO planetenDAO;
    private DefaultCategoryDataset dataset;

    @Inject
    public ExoplanetsPerStarChart(IChartRepository iChartRepository, IPlanetenDAO iPlanetenDAO) {
        this.planetenDAO = iPlanetenDAO;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        for (int i = 8; i > 0; --i) {
            int n = this.planetenDAO.zaehleAnzahlSterneMitExoplaneten(i);
            if (n <= 0) continue;
            this.dataset.addValue(n, (Comparable)((Object)("" + i)), (Comparable)((Object)""));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.getChartName(), this.sprache.getString("sim_gui195"), this.sprache.getString("sim_m54"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui113");
    }

    @Override
    public String getChartKey() {
        return "sim_gui113";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_PLANETEN_PRO_STERN;
    }
}

