/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.PlanetDto;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.simulationen.diagramme.PlanetennamenAuswaehlerUtil;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class HabitableZoneChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IPlanetenDAO planetenDAO;
    private XYSeriesCollection collection;
    private String chartName;

    @Inject
    public HabitableZoneChart(IChartRepository iChartRepository, IPlanetenDAO iPlanetenDAO) {
        this.planetenDAO = iPlanetenDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.chartName = this.i18n.getString("sim_gui165");
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        PlanetennamenAuswaehlerUtil planetennamenAuswaehlerUtil = new PlanetennamenAuswaehlerUtil();
        double d = 0.0157;
        double d2 = 0.15164;
        List<PlanetDto> list = this.planetenDAO.getPlanetsInHabitableZone(d, d2);
        this.chartName = this.i18n.getString("sim_gui165") + " (" + this.i18n.toLocalisedInt(list.size()) + " " + this.i18n.getString("sim_gui110") + ")";
        for (PlanetDto planetDto : list) {
            long l;
            Object object = null;
            if (planetDto.getPlanetMJup() != null && planetDto.getPlanetMJup() > 0.0) {
                l = Math.round(planetDto.getPlanetMJup() * 10.0 * 317.87746903247404);
                object = this.i18n.toLocalisedDouble((double)l / 10.0) + " " + this.i18n.getString("knn_earth_mass");
            }
            if (planetDto.getPlanetDJup() != null && planetDto.getPlanetDJup() > 0.0) {
                object = object != null ? object + ", " : "";
                l = Math.round(planetDto.getPlanetDJup() * 10.0 * 11.194418312950768);
                object = (String)object + this.i18n.toLocalisedDouble((double)l / 10.0) + " " + this.i18n.getString("knn_earth_diameter");
            }
            String string = planetennamenAuswaehlerUtil.getBekannterName(planetDto.getPlanetNames());
            XYSeries xYSeries = new XYSeries((Comparable)((Object)(string + (String)(object != null ? " (" + (String)object + ")" : ""))));
            xYSeries.add(planetDto.getPlanetOrbitInDays(), planetDto.getStarTemperature());
            this.collection.addSeries(xYSeries);
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.i18n.getString("db_m220"), this.i18n.getString("db_m231"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.chartName;
    }

    @Override
    public String getChartKey() {
        return "sim_gui165";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_HZ;
    }
}

