/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenEntdeckungsmethodeDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class MassAndDistanceOfExoplanetsChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IPlanetenEntdeckungsmethodeDAO planetenDAO;
    private DiagrammHelfer helfer;
    private XYSeriesCollection collection;
    private double maxEntfernung;
    private final IEntdeckungsmethodenRepository entdeckungsmethodenRepository;

    @Inject
    public MassAndDistanceOfExoplanetsChart(IChartRepository iChartRepository, IPlanetenEntdeckungsmethodeDAO iPlanetenEntdeckungsmethodeDAO, IEntdeckungsmethodenRepository iEntdeckungsmethodenRepository) {
        this.planetenDAO = iPlanetenEntdeckungsmethodeDAO;
        this.entdeckungsmethodenRepository = iEntdeckungsmethodenRepository;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.i18n);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
        this.maxEntfernung = this.helfer.zeigeEingabeDialog(null, this.i18n.getString("sim_m13"), this.i18n.getString("ps_planeten"), 6.0, "AE", 0.5, new double[0]);
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        List<ErgebnisXYDto> list = this.planetenDAO.getMasseUndBahnabstand(this.maxEntfernung, true, null);
        XYSeries xYSeries = new XYSeries((Comparable)((Object)(this.i18n.getString("sim_m27") + " (" + this.i18n.toLocalisedInt(list.size()) + ")")));
        for (ErgebnisXYDto object2 : list) {
            xYSeries.add(object2.getX(), object2.getY());
        }
        this.collection.addSeries(xYSeries);
        List<String> list2 = this.entdeckungsmethodenRepository.getEntdeckungsmethoden();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            list = this.planetenDAO.getMasseUndBahnabstand(this.maxEntfernung, false, string);
            String string2 = this.i18n.getUebersetzungFuerAktuelleSprache(string) + " (" + this.i18n.toLocalisedInt(list.size()) + " " + this.i18n.getString("sim_gui110") + ")";
            XYSeries xYSeries2 = new XYSeries((Comparable)((Object)string2));
            for (ErgebnisXYDto ergebnisXYDto : list) {
                xYSeries2.add(ergebnisXYDto.getX(), ergebnisXYDto.getY());
            }
            this.collection.addSeries(xYSeries2);
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.i18n.getString("sim_m75"), this.i18n.getString("sim_m76"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui22");
    }

    @Override
    public String getChartKey() {
        return "sim_gui22";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_MASSE_ENTFERNUNG;
    }
}

