/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class MetallicityAndExoplanetsChart
implements IChart {
    private final ISprachcontainer i18n;
    private final ISterneDAO sterneDAO;
    private XYSeriesCollection collection;

    @Inject
    public MetallicityAndExoplanetsChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO) {
        this.sterneDAO = iSterneDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        String[] stringArray;
        int n;
        this.collection = new XYSeriesCollection();
        List<String> list = this.sterneDAO.getAnzahlPlanetenProMetallizitaet(false);
        XYSeries xYSeries = new XYSeries((Comparable)((Object)(this.i18n.getString("sim_m22") + " (" + this.i18n.toLocalisedInt(list.size()) + ")")));
        for (n = 0; n < list.size(); ++n) {
            stringArray = list.get(n).split(";;");
            xYSeries.add(Double.parseDouble(stringArray[0]), Integer.parseInt(stringArray[1]));
        }
        this.collection.addSeries(xYSeries);
        list = this.sterneDAO.getAnzahlPlanetenProMetallizitaet(true);
        xYSeries = new XYSeries((Comparable)((Object)(this.i18n.getString("sim_m23") + " (" + this.i18n.toLocalisedInt(list.size()) + ")")));
        for (n = 0; n < list.size(); ++n) {
            stringArray = list.get(n).split(";;");
            xYSeries.add(Double.parseDouble(stringArray[0]), Integer.parseInt(stringArray[1]));
        }
        this.collection.addSeries(xYSeries);
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.i18n.getString("sim_m58"), this.i18n.getString("sim_gui195"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui16");
    }

    @Override
    public String getChartKey() {
        return "sim_gui16";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_METALIZITAET;
    }
}

