/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenPhtDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class PlanetRadiusPeriodAndPhtCandidatesChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IPlanetenPhtDAO planetenDAO;
    private XYSeriesCollection collection;

    @Inject
    public PlanetRadiusPeriodAndPhtCandidatesChart(IChartRepository iChartRepository, IPlanetenPhtDAO iPlanetenPhtDAO) {
        this.planetenDAO = iPlanetenPhtDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        Map<String, List<ErgebnisXYDto>> map = this.planetenDAO.findPlanetRadiusAndPeriodForPht();
        for (Map.Entry<String, List<ErgebnisXYDto>> entry : map.entrySet()) {
            XYSeries xYSeries = new XYSeries((Comparable)((Object)(entry.getKey() + " (" + this.i18n.toLocalisedInt(entry.getValue().size()) + ")")));
            for (ErgebnisXYDto ergebnisXYDto : entry.getValue()) {
                xYSeries.add(ergebnisXYDto.getX(), ergebnisXYDto.getY());
            }
            this.collection.addSeries(xYSeries);
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.i18n.getString("sim_gui190"), this.i18n.getString("sim_gui183"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui189");
    }

    @Override
    public String getChartKey() {
        return "sim_gui189";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_RADIUS_PERIOD_PHT;
    }
}

