/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.datamodel.formeln.PlanetSystemTypeCalculator;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.planeten.ExoplanetSystemTypesRepository;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class PlanetSystemTypesChart
implements IChart {
    private final ISprachcontainer i18n = SprachcontainerFabrik.getSprachcontainer();
    private DefaultCategoryDataset dataset;
    private String titel;
    private final ExoplanetSystemTypesRepository repo;

    @Inject
    public PlanetSystemTypesChart(IChartRepository iChartRepository, ExoplanetSystemTypesRepository exoplanetSystemTypesRepository) {
        iChartRepository.register(this);
        this.repo = exoplanetSystemTypesRepository;
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.titel, this.i18n.getString("sim_gui209"), this.i18n.getString("sim_gui208"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return new ChartPanel(jFreeChart);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui207");
    }

    @Override
    public String getChartKey() {
        return "sim_gui207";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public void collectData() throws SQLException {
        Map<PlanetSystemTypeCalculator.PlanetSystemType, Integer> map = this.repo.getNumberOfPlanetSystemsPerType();
        int n = 0;
        for (Integer object : map.values()) {
            n += object.intValue();
        }
        this.titel = this.i18n.toLocalisedInt(n) + " " + this.i18n.getString("sim_gui210");
        this.dataset = new DefaultCategoryDataset();
        for (Map.Entry entry : map.entrySet()) {
            double d = (double)((Integer)entry.getValue()).intValue() * 100.0 / (double)n;
            String string = this.i18n.getString("sim_" + ((PlanetSystemTypeCalculator.PlanetSystemType)((Object)entry.getKey())).name());
            this.dataset.addValue((Number)entry.getValue(), (Comparable)((Object)(string + " (" + this.i18n.toLocalisedDouble(d) + "%)")), (Comparable)((Object)string));
        }
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_SYSTEM_TYPEN;
    }
}

