/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.simulationen.diagramme.util.MedianCalculator;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class RvErrorMassExoplanetChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IPlanetenDAO planetenDAO;
    private XYSeriesCollection collection;
    private double medianSingleStars;
    private double medianDoubleStars;
    private double medianVariableStars;

    @Inject
    public RvErrorMassExoplanetChart(IChartRepository iChartRepository, IPlanetenDAO iPlanetenDAO) {
        this.planetenDAO = iPlanetenDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        List<ErgebnisXYDto> list2 = this.planetenDAO.getStarsWithPlanetMassAndRvError(List.of(StarObjectType.SINGLE_STAR, StarObjectType.DOUBLE_STAR_OPTICAL));
        XYSeries xYSeries = new XYSeries((Comparable)((Object)(this.i18n.getString("sim_m166") + " (" + this.i18n.toLocalisedInt(list2.size()) + ")")));
        for (ErgebnisXYDto list3 : list2) {
            xYSeries.add(list3.getX(), list3.getY());
            arrayList.add(list3.getY());
        }
        this.collection.addSeries(xYSeries);
        this.medianSingleStars = MedianCalculator.calculateMedian(arrayList);
        arrayList = new ArrayList();
        List<ErgebnisXYDto> list4 = this.planetenDAO.getStarsWithPlanetMassAndRvError(List.of(StarObjectType.DOUBLE_STAR_REAL, StarObjectType.ECLIPSING_BINARY, StarObjectType.MULTI_STAR_SYSTEM));
        xYSeries = new XYSeries((Comparable)((Object)(this.i18n.getString("sim_m167") + " (" + this.i18n.toLocalisedInt(list4.size()) + ")")));
        Iterator iterator = list4.iterator();
        while (iterator.hasNext()) {
            ErgebnisXYDto ergebnisXYDto = (ErgebnisXYDto)iterator.next();
            xYSeries.add(ergebnisXYDto.getX(), ergebnisXYDto.getY());
            arrayList.add(ergebnisXYDto.getY());
        }
        this.collection.addSeries(xYSeries);
        this.medianDoubleStars = MedianCalculator.calculateMedian(arrayList);
        arrayList = new ArrayList();
        List<ErgebnisXYDto> list = this.planetenDAO.getStarsWithPlanetMassAndRvError(List.of(StarObjectType.VARIABLE_HALF_REGULAR, StarObjectType.VARIABLE_IRREGULAR, StarObjectType.VARIABLE_LONG_PERIOD, StarObjectType.VARIABLE_SHORT_PERIOD, StarObjectType.VARIABLE_UNKNOWN_TYPE));
        xYSeries = new XYSeries((Comparable)((Object)(this.i18n.getString("sim_m168") + " (" + this.i18n.toLocalisedInt(list.size()) + ")")));
        for (ErgebnisXYDto ergebnisXYDto : list) {
            xYSeries.add(ergebnisXYDto.getX(), ergebnisXYDto.getY());
            arrayList.add(ergebnisXYDto.getY());
        }
        this.collection.addSeries(xYSeries);
        this.medianVariableStars = MedianCalculator.calculateMedian(arrayList);
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.i18n.getString("sim_m164"), this.i18n.getString("sim_m165"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        ValueMarker valueMarker = new ValueMarker(this.medianSingleStars);
        valueMarker.setPaint(Color.black);
        xYPlot.addRangeMarker(valueMarker);
        valueMarker = new ValueMarker(this.medianDoubleStars);
        valueMarker.setPaint(Color.black);
        xYPlot.addRangeMarker(valueMarker);
        valueMarker = new ValueMarker(this.medianVariableStars);
        valueMarker.setPaint(Color.black);
        xYPlot.addRangeMarker(valueMarker);
        LegendItemCollection legendItemCollection = xYPlot.getLegendItems();
        LegendItem legendItem = new LegendItem(this.i18n.getString("sim_m174", this.medianSingleStars, this.medianDoubleStars, this.medianVariableStars));
        legendItemCollection.add(legendItem);
        xYPlot.setFixedLegendItems(legendItemCollection);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui197");
    }

    @Override
    public String getChartKey() {
        return "sim_gui197";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_RV_ERROR_MASSE;
    }
}

