/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.repos.IEntdeckungsmethodenRepository;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenEntdeckungsmethodeDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class StarBrigthnessAndDistanceOfExoplanetsChart
implements IChart {
    private final ISprachcontainer i18n;
    private DiagrammHelfer helfer;
    private XYSeriesCollection collection;
    private double maxEntfernung;
    private final IEntdeckungsmethodenRepository entdeckungsmethodenRepository;
    private final IPlanetenEntdeckungsmethodeDAO planetenDAO;

    @Inject
    public StarBrigthnessAndDistanceOfExoplanetsChart(IChartRepository iChartRepository, IEntdeckungsmethodenRepository iEntdeckungsmethodenRepository, IPlanetenEntdeckungsmethodeDAO iPlanetenEntdeckungsmethodeDAO) {
        this.entdeckungsmethodenRepository = iEntdeckungsmethodenRepository;
        this.planetenDAO = iPlanetenEntdeckungsmethodeDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.i18n);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
        this.maxEntfernung = this.helfer.zeigeEingabeDialog(null, this.i18n.getString("sim_m9"), this.i18n.getString("sim_m10"), 1000.0, "ly", 50.0, new double[0]);
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        List<String> list = this.entdeckungsmethodenRepository.getEntdeckungsmethoden();
        for (String string : list) {
            List<ErgebnisXYDto> list2 = this.planetenDAO.getScheinbareHelligkeitUndEntfernungSterneMitPlaneten(this.maxEntfernung, string);
            String string2 = this.i18n.getUebersetzungFuerAktuelleSprache(string) + " (" + this.i18n.toLocalisedInt(list2.size()) + " " + this.i18n.getString("sim_m24") + ")";
            XYSeries xYSeries = new XYSeries((Comparable)((Object)string2));
            for (ErgebnisXYDto ergebnisXYDto : list2) {
                xYSeries.add(ergebnisXYDto.getX(), ergebnisXYDto.getY());
            }
            this.collection.addSeries(xYSeries);
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.i18n.getString("sim_m68"), this.i18n.getString("sim_m74"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui20");
    }

    @Override
    public String getChartKey() {
        return "sim_gui20";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_STERN_VMAG_ENTFERNUNG;
    }
}

