/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class StarMassAndMassOfExoplanetsChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IPlanetenDAO planetenDAO;
    private XYSeriesCollection collection;

    @Inject
    public StarMassAndMassOfExoplanetsChart(IChartRepository iChartRepository, IPlanetenDAO iPlanetenDAO) {
        this.planetenDAO = iPlanetenDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        double[][] dArray = this.planetenDAO.getSonnenmasseUndPlanetenmassen(2);
        XYSeries xYSeries = new XYSeries((Comparable)((Object)(this.i18n.getString("sim_gui110") + " (" + this.i18n.toLocalisedInt(dArray.length) + ")")));
        for (int i = 0; i < dArray.length; ++i) {
            xYSeries.add(dArray[i][1], dArray[i][0]);
        }
        this.collection.addSeries(xYSeries);
        dArray = this.planetenDAO.getSonnenmasseUndPlanetenmassen(3);
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)this.i18n.getString("sim_gui65")));
        xYSeries2.add(dArray[0][1], dArray[0][0]);
        this.collection.addSeries(xYSeries2);
        dArray = this.planetenDAO.getSonnenmasseUndPlanetenmassen(1);
        XYSeries xYSeries3 = new XYSeries((Comparable)((Object)(this.i18n.getString("sim_m116") + " (" + this.i18n.toLocalisedInt(dArray.length) + ")")));
        for (int i = 0; i < dArray.length; ++i) {
            xYSeries3.add(dArray[i][1], dArray[i][0]);
        }
        this.collection.addSeries(xYSeries3);
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.i18n.getString("sim_m122"), this.i18n.getString("sim_m123"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_m121");
    }

    @Override
    public String getChartKey() {
        return "sim_m121";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_STERN_MASSE_PLANETEN_MASSE;
    }
}

