/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.datamodel.formeln.DensityCalculator;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class SuperearthsDiameterAndMassChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IPlanetenDAO planetenDAO;
    private XYSeriesCollection collection;
    private String title;

    @Inject
    public SuperearthsDiameterAndMassChart(IChartRepository iChartRepository, IPlanetenDAO iPlanetenDAO) {
        this.planetenDAO = iPlanetenDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.title = this.i18n.getString("sim_gui106");
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        this.collection.addSeries(new XYSeries((Comparable)((Object)">5.0 g/cm\u00b3")));
        this.collection.addSeries(new XYSeries((Comparable)((Object)"4.0-5.0 g/cm\u00b3")));
        this.collection.addSeries(new XYSeries((Comparable)((Object)"3.0-4.0 g/cm\u00b3")));
        this.collection.addSeries(new XYSeries((Comparable)((Object)"<3.0 g/cm\u00b3")));
        List<PlanetensucheObjekt> list = this.planetenDAO.getSupererden();
        this.title = this.i18n.toLocalisedInt(list.size()) + " " + this.i18n.getString("sim_gui106");
        for (PlanetensucheObjekt planetensucheObjekt : list) {
            Optional<Double> optional = DensityCalculator.calcDensityInGcmCubic(planetensucheObjekt);
            if (!optional.isPresent()) continue;
            XYSeries xYSeries = this.collection.getSeries((Comparable)((Object)this.getPartName(optional.get())));
            double d = planetensucheObjekt.getMasse() / 0.00314;
            double d2 = planetensucheObjekt.getDurchmesser() / 0.0892;
            xYSeries.add(d, d2);
        }
    }

    private String getPartName(Double d) {
        if (d > 5.0) {
            return ">5.0 g/cm\u00b3";
        }
        if (d >= 4.0) {
            return "4.0-5.0 g/cm\u00b3";
        }
        if (d >= 3.0) {
            return "3.0-4.0 g/cm\u00b3";
        }
        return "<3.0 g/cm\u00b3";
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.i18n.getString("sim_m137"), this.i18n.getString("sim_m136"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.title;
    }

    @Override
    public String getChartKey() {
        return "sim_gui106";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_SUPERERDEN_DURCHMESSER_MASSE;
    }
}

