/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.ObjektnamenSortierung;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.simulationen.diagramme.PlanetennamenAuswaehlerUtil;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class SuperearthsInHabitableZone2Chart
implements IChart {
    private final ISprachcontainer sprache;
    private final IPlanetenDAO planetenDAO;
    private final IObjektnamenRepository objektnamenRepository;
    private final DiagrammHelfer helfer;
    private XYSeriesCollection collection;
    private double maxErdMasse;

    @Inject
    public SuperearthsInHabitableZone2Chart(IChartRepository iChartRepository, IPlanetenDAO iPlanetenDAO, IObjektnamenRepository iObjektnamenRepository) {
        this.planetenDAO = iPlanetenDAO;
        this.objektnamenRepository = iObjektnamenRepository;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.sprache);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
        this.maxErdMasse = this.helfer.zeigeEingabeDialog(null, this.sprache.getString("sim_m11"), this.sprache.getString("ps_planeten"), 10.0, this.sprache.getString("sim_m137"), 1.1, 10.0);
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        PlanetennamenAuswaehlerUtil planetennamenAuswaehlerUtil = new PlanetennamenAuswaehlerUtil();
        List<PlanetensucheObjekt> list = this.planetenDAO.getSupererdenInGruenerZone(this.maxErdMasse);
        for (PlanetensucheObjekt planetensucheObjekt : list) {
            List<String> list2 = this.objektnamenRepository.getNamenByDatenId(planetensucheObjekt.getDatenid(), ObjektnamenSortierung.BEKANNTHEIT);
            String string = planetennamenAuswaehlerUtil.getBekannterName(list2);
            XYSeries xYSeries = new XYSeries((Comparable)((Object)string));
            xYSeries.add(planetensucheObjekt.getEntfernung(), planetensucheObjekt.getTemperatur());
            this.collection.addSeries(xYSeries);
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("db_m215"), this.sprache.getString("fs_m31"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui118");
    }

    @Override
    public String getChartKey() {
        return "sim_gui118";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_SUPERERDEN_HZ2;
    }
}

