/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.planeten;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.JDoubleFieldWithLabel;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.TemperaturParameterDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.TemperaturResultDto;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class TemperatureOfPlanetsChart
implements IChart {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final ISprachcontainer i18n;
    private final IPlanetenDAO planetenDAO;
    private XYSeriesCollection collection;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;
    private final JDoubleFieldWithLabel orbitAxisInputMin;
    private final JDoubleFieldWithLabel orbitAxisInputMax;
    private final JDoubleFieldWithLabel temperaturInputMin;
    private final JDoubleFieldWithLabel temperaturInputMax;
    private final JCheckBox earthLikeTempCheckBox;
    private String chartName;

    @Inject
    public TemperatureOfPlanetsChart(IChartRepository iChartRepository, IPlanetenDAO iPlanetenDAO, IPlanetensucheObjektRepository iPlanetensucheObjektRepository, IObjektnamenRepository iObjektnamenRepository) {
        this.planetenDAO = iPlanetenDAO;
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.objektnamenRepository = iObjektnamenRepository;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
        this.orbitAxisInputMin = new JDoubleFieldWithLabel(this.i18n.getString("sim_gui123"));
        this.orbitAxisInputMax = new JDoubleFieldWithLabel(this.i18n.getString("sim_gui122"));
        this.temperaturInputMin = new JDoubleFieldWithLabel(this.i18n.getString("sim_gui125"));
        this.temperaturInputMax = new JDoubleFieldWithLabel(this.i18n.getString("sim_gui124"));
        this.earthLikeTempCheckBox = new JCheckBox(this.i18n.getString("sim_gui126"), false);
        this.chartName = this.i18n.getString("sim_gui98");
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        XYSeries xYSeries;
        this.collection = new XYSeriesCollection();
        TemperaturParameterDto temperaturParameterDto = new TemperaturParameterDto();
        temperaturParameterDto.setNurErdaehnliche(this.earthLikeTempCheckBox.isSelected());
        temperaturParameterDto.setMaxBahnabstandAE(this.orbitAxisInputMax.getDoubleInput());
        temperaturParameterDto.setMinBahnabstandAE(this.orbitAxisInputMin.getDoubleInput());
        if (this.temperaturInputMax.isEnabled()) {
            temperaturParameterDto.setMaxTemperatur(this.temperaturInputMax.getDoubleInput());
        }
        if (this.temperaturInputMin.isEnabled()) {
            temperaturParameterDto.setMinTemperatur(this.temperaturInputMin.getDoubleInput());
        }
        List<TemperaturResultDto> list = this.planetenDAO.getOberflaechentemperaturUndBahnabstand(temperaturParameterDto);
        this.chartName = this.i18n.getString("sim_gui98") + " (" + this.i18n.toLocalisedInt(list.size()) + " " + this.i18n.getString("sim_gui110") + ")";
        for (TemperaturResultDto object2 : list) {
            xYSeries = new XYSeries((Comparable)((Object)object2.getPlanetName()));
            xYSeries.add(object2.getBahnabstandAE(), (Number)object2.getTemperatur());
            this.collection.addSeries(xYSeries);
        }
        Object object3 = this.objektnamenRepository.getIDFuerNamen("Merkur", true);
        if (object3 != null) {
            IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read((Integer)object3);
            xYSeries = new XYSeries((Comparable)((Object)this.i18n.getString("ps_merkur")));
            xYSeries.add(iPlanetensucheObjekt.getEntfernung(), iPlanetensucheObjekt.getTemperatur());
            this.collection.addSeries(xYSeries);
        }
        if ((object3 = this.objektnamenRepository.getIDFuerNamen("Venus", true)) != null) {
            IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read((Integer)object3);
            xYSeries = new XYSeries((Comparable)((Object)this.i18n.getString("ps_venus")));
            xYSeries.add(iPlanetensucheObjekt.getEntfernung(), iPlanetensucheObjekt.getTemperatur());
            this.collection.addSeries(xYSeries);
        }
        if ((object3 = this.objektnamenRepository.getIDFuerNamen("Erde", true)) != null) {
            IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read((Integer)object3);
            xYSeries = new XYSeries((Comparable)((Object)this.i18n.getString("sim_m92")));
            xYSeries.add(iPlanetensucheObjekt.getEntfernung(), iPlanetensucheObjekt.getTemperatur());
            this.collection.addSeries(xYSeries);
        }
        if ((object3 = this.objektnamenRepository.getIDFuerNamen("Mars", true)) != null) {
            IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read((Integer)object3);
            xYSeries = new XYSeries((Comparable)((Object)this.i18n.getString("ps_mars")));
            xYSeries.add(iPlanetensucheObjekt.getEntfernung(), iPlanetensucheObjekt.getTemperatur());
            this.collection.addSeries(xYSeries);
        }
        if ((object3 = this.objektnamenRepository.getIDFuerNamen("Jupiter", true)) != null) {
            IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read((Integer)object3);
            xYSeries = new XYSeries((Comparable)((Object)this.i18n.getString("ps_jupiter")));
            xYSeries.add(iPlanetensucheObjekt.getEntfernung(), iPlanetensucheObjekt.getTemperatur());
            this.collection.addSeries(xYSeries);
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.i18n.getString("sim_m75"), this.i18n.getString("db_m231"), this.collection, PlotOrientation.VERTICAL, false, true, false);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setName("chartPanel");
        JPanel jPanel = this.createParameterPanel(chartPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("overallChartPanel");
        jPanel2.setLayout(new BorderLayout(10, 10));
        jPanel2.add((Component)jPanel, "First");
        jPanel2.add((Component)chartPanel, "Center");
        jPanel2.revalidate();
        return jPanel2;
    }

    private JPanel createParameterPanel(ChartPanel chartPanel) {
        JPanel jPanel = new JPanel();
        jPanel.setName("parameterPanel");
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(LineBorder.createBlackLineBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.orbitAxisInputMin, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.orbitAxisInputMax, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.temperaturInputMin, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this.temperaturInputMax, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        jPanel.add((Component)this.earthLikeTempCheckBox, gridBagConstraints);
        JButton jButton = new JButton(this.i18n.getString("sim_gui127"));
        jButton.addActionListener(actionEvent -> {
            try {
                this.collectData();
                JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.i18n.getString("sim_m75"), this.i18n.getString("db_m231"), this.collection, PlotOrientation.VERTICAL, false, true, false);
                chartPanel.setChart(jFreeChart);
                chartPanel.repaint();
            }
            catch (SQLException sQLException) {
                this.logging.error(sQLException);
            }
        });
        gridBagConstraints.gridx = 5;
        jPanel.add((Component)jButton, gridBagConstraints);
        this.earthLikeTempCheckBox.addChangeListener(changeEvent -> {
            if (this.earthLikeTempCheckBox.isSelected()) {
                this.temperaturInputMin.setEnabled(false);
                this.temperaturInputMax.setEnabled(false);
            } else {
                this.temperaturInputMin.setEnabled(true);
                this.temperaturInputMax.setEnabled(true);
            }
        });
        return jPanel;
    }

    @Override
    public String getChartName() {
        return this.chartName;
    }

    @Override
    public String getChartKey() {
        return "sim_gui98";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_planeten");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_PLANETEN_TEMPERATUR;
    }
}

