/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.statistik;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IGalaxienNebelDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class NumberOfClassesOfNebulasChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IDatenbankService datenbankService;
    private final IGalaxienNebelDAO galaxienNebelDAO;
    private DefaultCategoryDataset dataset;

    @Inject
    public NumberOfClassesOfNebulasChart(IChartRepository iChartRepository, IGalaxienNebelDAO iGalaxienNebelDAO, IDatenbankService iDatenbankService) {
        this.galaxienNebelDAO = iGalaxienNebelDAO;
        this.datenbankService = iDatenbankService;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        int n;
        this.dataset = new DefaultCategoryDataset();
        List<String> list = this.datenbankService.getNebelformen("");
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            n2 += this.galaxienNebelDAO.getAnzahlNebelarten(list.get(n));
        }
        if (n2 == 0) {
            return;
        }
        for (n = 0; n < list.size(); ++n) {
            int n3 = this.galaxienNebelDAO.getAnzahlNebelarten(list.get(n));
            String string = this.i18n.getUebersetzungFuerAktuelleSprache(list.get(n));
            this.dataset.addValue(n3, (Comparable)((Object)(string + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 1000.0 / (double)n2) / 10.0) + "%)")), (Comparable)((Object)""));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.getChartName(), this.i18n.getString("sim_m60"), this.i18n.getString("sim_m61"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui55");
    }

    @Override
    public String getChartKey() {
        return "sim_gui55";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("sim_gui49");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STATISTIK_NEBEL_KLASSEN;
    }
}

