/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.statistik;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.basis.CountDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IPlanetenDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.simulationen.diagramme.statistik.ObjectNameDialogCreator;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class NumberOfEarthlikePlanetsChart
implements IChart {
    private final String wertUnbekanntKey = "sim_m40";
    private final ISprachcontainer sprache;
    private final IPlanetenDAO planetenDAO;
    private DefaultCategoryDataset dataset;
    private final IObjektnamenRepository objektnamenRepository;

    @Inject
    public NumberOfEarthlikePlanetsChart(IChartRepository iChartRepository, IPlanetenDAO iPlanetenDAO, IObjektnamenRepository iObjektnamenRepository) {
        this.planetenDAO = iPlanetenDAO;
        this.objektnamenRepository = iObjektnamenRepository;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        double d = 0.002826;
        double d2 = 0.0034540000000000005;
        double d3 = 0.89;
        double d4 = 1.11;
        double d5 = 0.0;
        double d6 = 0.1;
        CountDto countDto = this.planetenDAO.getAEJupiteraehnlicherPlaneten(d4, d3);
        this.dataset.addValue(countDto.getCountObjectsNoValues(), (Comparable)((Object)this.sprache.getString("sim_m40")), (Comparable)((Object)(this.sprache.getString("sim_m13") + " (" + d3 + " - " + d4 + ")")));
        this.dataset.addValue(countDto.getCountObjectsNonEquals(), (Comparable)((Object)this.sprache.getString("sim_m44")), (Comparable)((Object)(this.sprache.getString("sim_m13") + " (" + d3 + " - " + d4 + ")")));
        this.dataset.addValue(countDto.getCountObjectsEquals(), (Comparable)((Object)this.sprache.getString("sim_m46")), (Comparable)((Object)(this.sprache.getString("sim_m13") + " (" + d3 + " - " + d4 + ")")));
        countDto = this.planetenDAO.getMasseJupiteraehnlicherPlaneten(d2, d);
        this.dataset.addValue(countDto.getCountObjectsNoValues(), (Comparable)((Object)this.sprache.getString("sim_m40")), (Comparable)((Object)(this.sprache.getString("sim_m11") + " (" + d + " - " + d2 + ")")));
        this.dataset.addValue(countDto.getCountObjectsNonEquals(), (Comparable)((Object)this.sprache.getString("sim_m44")), (Comparable)((Object)(this.sprache.getString("sim_m11") + " (" + d + " - " + d2 + ")")));
        this.dataset.addValue(countDto.getCountObjectsEquals(), (Comparable)((Object)this.sprache.getString("sim_m46")), (Comparable)((Object)(this.sprache.getString("sim_m11") + " (" + d + " - " + d2 + ")")));
        countDto = this.planetenDAO.getExzentritaetJupiteraehnlicherPlaneten(d6, d5);
        this.dataset.addValue(countDto.getCountObjectsNoValues(), (Comparable)((Object)this.sprache.getString("sim_m40")), (Comparable)((Object)(this.sprache.getString("db_m111") + " (" + d5 + " - " + d6 + ")")));
        this.dataset.addValue(countDto.getCountObjectsNonEquals(), (Comparable)((Object)this.sprache.getString("sim_m44")), (Comparable)((Object)(this.sprache.getString("db_m111") + " (" + d5 + " - " + d6 + ")")));
        this.dataset.addValue(countDto.getCountObjectsEquals(), (Comparable)((Object)this.sprache.getString("sim_m46")), (Comparable)((Object)(this.sprache.getString("db_m111") + " (" + d5 + " - " + d6 + ")")));
        countDto = this.planetenDAO.getJupiteraehnlichePlaneten2(d, d2, d3, d4, d5, d6);
        this.dataset.addValue(countDto.getCountObjectsNoValues(), (Comparable)((Object)this.sprache.getString("sim_m40")), (Comparable)((Object)this.sprache.getString("sim_m43")));
        this.dataset.addValue(countDto.getCountObjectsNonEquals(), (Comparable)((Object)this.sprache.getString("sim_m44")), (Comparable)((Object)this.sprache.getString("sim_m43")));
        this.dataset.addValue(countDto.getCountObjectsEquals(), (Comparable)((Object)this.sprache.getString("sim_m46")), (Comparable)((Object)this.sprache.getString("sim_m43")));
        ObjectNameDialogCreator objectNameDialogCreator = new ObjectNameDialogCreator(this.objektnamenRepository);
        objectNameDialogCreator.zeigeDialogMitObjektnamen(this.sprache.getString("sim_gui61"), countDto.getDatenIdsObjectsEquals());
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(this.getChartName(), this.sprache.getString("sim_m85"), this.sprache.getString("sim_gui195"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui61");
    }

    @Override
    public String getChartKey() {
        return "sim_gui61";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("sim_gui49");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STATISTIK_ERDAENLICHE_PLANETEN;
    }
}

