/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.statistik;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IObjekttypenRepository;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISternhaufenDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class NumberOfGlobularClustersChart
implements IChart {
    private final ISprachcontainer i18n;
    private final IDatenbankService datenbankService;
    private final ISternhaufenDAO sternhaufenDAO;
    private DefaultCategoryDataset dataset;
    private final IObjekttypenRepository objekttypenRepository;

    @Inject
    public NumberOfGlobularClustersChart(IChartRepository iChartRepository, ISternhaufenDAO iSternhaufenDAO, IDatenbankService iDatenbankService, IObjekttypenRepository iObjekttypenRepository) {
        this.sternhaufenDAO = iSternhaufenDAO;
        this.datenbankService = iDatenbankService;
        this.objekttypenRepository = iObjekttypenRepository;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        int n;
        this.dataset = new DefaultCategoryDataset();
        Integer n2 = this.objekttypenRepository.read("Kugelsternhaufen").getId();
        List<String> list = this.datenbankService.getSternhaufenformen("Kugelsternhaufen");
        int n3 = 0;
        for (n = 0; n < list.size(); ++n) {
            n3 += this.sternhaufenDAO.getAnzahlSternhaufen(list.get(n), n2);
        }
        if (n3 == 0) {
            return;
        }
        for (n = 0; n < list.size(); ++n) {
            int n4 = this.sternhaufenDAO.getAnzahlSternhaufen(list.get(n), n2);
            String string = this.i18n.getUebersetzungFuerAktuelleSprache(list.get(n));
            this.dataset.addValue(n4, (Comparable)((Object)(string + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n4 * 1000.0 / (double)n3) / 10.0) + "%)")), (Comparable)((Object)""));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.getChartName(), this.i18n.getString("sim_m65"), this.i18n.getString("sim_m67"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui54");
    }

    @Override
    public String getChartKey() {
        return "sim_gui54";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("sim_gui49");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STATISTIK_KUGELSTERNHAUFEN;
    }
}

