/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.statistik;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class NumberOfLuminosityClassOfStarsChart
implements IChart {
    private final ISprachcontainer i18n;
    private final ISterneDAO sterneDAO;
    private final IDatenbankService datenbankService;
    private DefaultCategoryDataset dataset;
    private final IKategorienRepository kategorienRepository;
    private String title;

    @Inject
    public NumberOfLuminosityClassOfStarsChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO, IKategorienRepository iKategorienRepository, IDatenbankService iDatenbankService) {
        this.sterneDAO = iSterneDAO;
        this.datenbankService = iDatenbankService;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.kategorienRepository = iKategorienRepository;
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        int n = this.kategorienRepository.getAnzahl(ObjektKategorie.STERNE.getKategorienName());
        this.title = this.getChartName() + " (" + this.i18n.toLocalisedNumber(n) + " " + this.i18n.getString("sim_m47") + ")";
        List<String> list = this.datenbankService.getLeuchtkraftklassen();
        for (String string : list) {
            int n2 = this.sterneDAO.getAnzahlLeuchtkraftklasse(string);
            if (n2 == -1) {
                n2 = 0;
            }
            String string2 = "";
            switch (string) {
                case "Ia": {
                    string2 = this.i18n.getString("sim_m32_1");
                    break;
                }
                case "Ib": {
                    string2 = this.i18n.getString("sim_m32_2");
                    break;
                }
                case "II": {
                    string2 = this.i18n.getString("sim_m33");
                    break;
                }
                case "III": {
                    string2 = this.i18n.getString("sim_m34");
                    break;
                }
                case "IV": {
                    string2 = this.i18n.getString("sim_m35");
                    break;
                }
                case "V": {
                    string2 = this.i18n.getString("sim_m36");
                    break;
                }
                case "VI": {
                    string2 = this.i18n.getString("sim_m37");
                    break;
                }
                case "VII": {
                    string2 = this.i18n.getString("sim_m31");
                    break;
                }
                default: {
                    string2 = this.i18n.getString("db_unbekannt");
                }
            }
            this.dataset.addValue(n2, (Comparable)((Object)(string2 + " (" + this.i18n.toLocalisedNumber((double)Math.round((double)n2 * 1000.0 / (double)n) / 10.0) + "%)")), (Comparable)((Object)string));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.title, this.i18n.getString("sim_m26"), this.i18n.getString("sim_m54"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui52");
    }

    @Override
    public String getChartKey() {
        return "sim_gui52";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("sim_gui49");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STATISTIK_ANZAHL_STERN_HELLIGKEITSKLASSEN;
    }
}

