/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.statistik;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class NumberOfSpektraltypesOfStarsChart
implements IChart {
    private final ISprachcontainer i18n;
    private final ISterneDAO sterneDAO;
    private final IDatenbankService datenbankService;
    private DefaultCategoryDataset dataset;
    private final IKategorienRepository kategorienRepository;
    private String title;

    @Inject
    public NumberOfSpektraltypesOfStarsChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO, IDatenbankService iDatenbankService, IKategorienRepository iKategorienRepository) {
        this.sterneDAO = iSterneDAO;
        this.datenbankService = iDatenbankService;
        this.kategorienRepository = iKategorienRepository;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        int n = this.kategorienRepository.getAnzahl(ObjektKategorie.STERNE.getKategorienName());
        this.title = this.getChartName() + " (" + this.i18n.toLocalisedInt(n) + " " + this.i18n.getString("sim_m47") + ")";
        int n2 = this.sterneDAO.getAnzahlSterneMitSpektraltyp("O");
        this.dataset.addValue(n2, (Comparable)((Object)("O " + this.i18n.toLocalisedDouble((double)Math.round((double)n2 * 1000.0 / (double)n) / 10.0) + "% " + this.i18n.getString("sim_gui72") + " (>" + this.i18n.toLocalisedInt(25000) + "K)")), (Comparable)((Object)"Sptyp"));
        n2 = this.sterneDAO.getAnzahlSterneMitSpektraltyp("B");
        this.dataset.addValue(n2, (Comparable)((Object)("B " + this.i18n.toLocalisedDouble((double)Math.round((double)n2 * 1000.0 / (double)n) / 10.0) + "% " + this.i18n.getString("sim_gui73") + " (" + this.i18n.toLocalisedInt(10000) + "-" + this.i18n.toLocalisedInt(25000) + "K)")), (Comparable)((Object)"Sptyp"));
        n2 = this.sterneDAO.getAnzahlSterneMitSpektraltyp("A");
        this.dataset.addValue(n2, (Comparable)((Object)("A " + this.i18n.toLocalisedDouble((double)Math.round((double)n2 * 1000.0 / (double)n) / 10.0) + "% " + this.i18n.getString("sim_gui74") + " (" + this.i18n.toLocalisedInt(7600) + "-" + this.i18n.toLocalisedInt(10000) + "K)")), (Comparable)((Object)"Sptyp"));
        n2 = this.sterneDAO.getAnzahlSterneMitSpektraltyp("F");
        this.dataset.addValue(n2, (Comparable)((Object)("F " + this.i18n.toLocalisedDouble((double)Math.round((double)n2 * 1000.0 / (double)n) / 10.0) + "% " + this.i18n.getString("sim_gui75") + " (" + this.i18n.toLocalisedInt(6000) + "-" + this.i18n.toLocalisedInt(7600) + "K)")), (Comparable)((Object)"Sptyp"));
        n2 = this.sterneDAO.getAnzahlSterneMitSpektraltyp("G");
        this.dataset.addValue(n2, (Comparable)((Object)("G " + this.i18n.toLocalisedDouble((double)Math.round((double)n2 * 1000.0 / (double)n) / 10.0) + "% " + this.i18n.getString("sim_gui76") + " (" + this.i18n.toLocalisedInt(5100) + "-" + this.i18n.toLocalisedInt(6000) + "K)")), (Comparable)((Object)"Sptyp"));
        n2 = this.sterneDAO.getAnzahlSterneMitSpektraltyp("K");
        this.dataset.addValue(n2, (Comparable)((Object)("K " + this.i18n.toLocalisedDouble((double)Math.round((double)n2 * 1000.0 / (double)n) / 10.0) + "% " + this.i18n.getString("sim_gui77") + " (" + this.i18n.toLocalisedInt(3600) + "-" + this.i18n.toLocalisedInt(5100) + "K)")), (Comparable)((Object)"Sptyp"));
        n2 = this.sterneDAO.getAnzahlSterneMitSpektraltyp("M");
        this.dataset.addValue(n2, (Comparable)((Object)("M " + this.i18n.toLocalisedDouble((double)Math.round((double)n2 * 1000.0 / (double)n) / 10.0) + "% " + this.i18n.getString("sim_gui78") + " (" + this.i18n.toLocalisedInt(2500) + "-" + this.i18n.toLocalisedInt(3600) + "K)")), (Comparable)((Object)"Sptyp"));
        List<String> list = this.datenbankService.getSpektraltypen(ObjektKategorie.STERNE.getKategorienName());
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).startsWith("D")) {
                n2 = this.sterneDAO.getAnzahlSterneMitSpektraltyp(list.get(i));
                this.dataset.addValue(n2, (Comparable)((Object)(this.i18n.toLocalisedDouble((double)Math.round((double)n2 * 1000.0 / (double)n) / 10.0) + "% " + list.get(i) + " " + this.i18n.getString("sim_m31"))), (Comparable)((Object)"Sptyp"));
                continue;
            }
            if (!list.get(i).startsWith("W")) continue;
            n2 = this.sterneDAO.getAnzahlSterneMitSpektraltyp(list.get(i));
            this.dataset.addValue(n2, (Comparable)((Object)(this.i18n.toLocalisedDouble((double)Math.round((double)n2 * 1000.0 / (double)n) / 10.0) + "% " + list.get(i))), (Comparable)((Object)"Sptyp"));
        }
        n2 = this.sterneDAO.getAnzahlSterneMitSpektraltyp("S");
        this.dataset.addValue(n2, (Comparable)((Object)(this.i18n.toLocalisedDouble((double)Math.round((double)n2 * 1000.0 / (double)n) / 10.0) + "% S")), (Comparable)((Object)"Sptyp"));
        n2 = this.sterneDAO.getAnzahlSterneMitSpektraltyp("unbekannt");
        this.dataset.addValue(n2, (Comparable)((Object)(this.i18n.toLocalisedDouble((double)Math.round((double)n2 * 1000.0 / (double)n) / 10.0) + "% " + this.i18n.getString("db_unbekannt"))), (Comparable)((Object)"Sptyp"));
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.title, this.i18n.getString("sim_gui70"), this.i18n.getString("sim_m54"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui51");
    }

    @Override
    public String getChartKey() {
        return "sim_gui51";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("sim_gui49");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STATISTIK_ANZAHL_SPTYPEN;
    }
}

