/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.statistik;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISonnenaehnlicheSterneDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.SonnenaehnlicheSterneDto;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.simulationen.diagramme.statistik.ObjectNameDialogCreator;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class NumberOfSunlikeStarsChart
implements IChart {
    private final String wertUnbekanntKey = "sim_m40";
    private final ISprachcontainer sprache;
    private final ISonnenaehnlicheSterneDAO sonnenaehnlicheSterneDao;
    private DefaultCategoryDataset dataset;
    private final IObjektnamenRepository objektnamenRepository;

    @Inject
    public NumberOfSunlikeStarsChart(IChartRepository iChartRepository, ISonnenaehnlicheSterneDAO iSonnenaehnlicheSterneDAO, IObjektnamenRepository iObjektnamenRepository) {
        this.sonnenaehnlicheSterneDao = iSonnenaehnlicheSterneDAO;
        this.objektnamenRepository = iObjektnamenRepository;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        double d = 0.89;
        double d2 = 1.11;
        double d3 = 0.55;
        double d4 = 0.75;
        double d5 = 4.62;
        double d6 = 5.02;
        double d7 = -0.1;
        double d8 = 0.1;
        double d9 = 4.2;
        double d10 = 5.0;
        List<Integer> list = this.sonnenaehnlicheSterneDao.getSpektraltypSonnenaehnlicherSterne();
        this.dataset.addValue(list.get(0), (Comparable)((Object)this.sprache.getString("sim_m40")), (Comparable)((Object)"Sptyp (G)"));
        this.dataset.addValue(list.get(1), (Comparable)((Object)this.sprache.getString("sim_m41")), (Comparable)((Object)"Sptyp (G)"));
        this.dataset.addValue(list.get(2), (Comparable)((Object)this.sprache.getString("sim_m42")), (Comparable)((Object)"Sptyp (G)"));
        list = this.sonnenaehnlicheSterneDao.getLeuchtkraftklasseSonnenaehnlicherSterne();
        this.dataset.addValue(list.get(0), (Comparable)((Object)this.sprache.getString("sim_m40")), (Comparable)((Object)(this.sprache.getString("sim_m26") + " (V)")));
        this.dataset.addValue(list.get(1), (Comparable)((Object)this.sprache.getString("sim_m41")), (Comparable)((Object)(this.sprache.getString("sim_m26") + " (V)")));
        this.dataset.addValue(list.get(2), (Comparable)((Object)this.sprache.getString("sim_m42")), (Comparable)((Object)(this.sprache.getString("sim_m26") + " (V)")));
        list = this.sonnenaehnlicheSterneDao.getMasseSonnenaehnlicherSterne(d2, d);
        this.dataset.addValue(list.get(0), (Comparable)((Object)this.sprache.getString("sim_m40")), (Comparable)((Object)(this.sprache.getString("sim_m11") + " (" + d + " - " + d2 + ")")));
        this.dataset.addValue(list.get(1), (Comparable)((Object)this.sprache.getString("sim_m41")), (Comparable)((Object)(this.sprache.getString("sim_m11") + " (" + d + " - " + d2 + ")")));
        this.dataset.addValue(list.get(2), (Comparable)((Object)this.sprache.getString("sim_m42")), (Comparable)((Object)(this.sprache.getString("sim_m11") + " (" + d + " - " + d2 + ")")));
        list = this.sonnenaehnlicheSterneDao.getBVSonnenaehnlicherSterne(d4, d3);
        this.dataset.addValue(list.get(0), (Comparable)((Object)this.sprache.getString("sim_m40")), (Comparable)((Object)("B-V (" + d3 + " - " + d4 + ")")));
        this.dataset.addValue(list.get(1), (Comparable)((Object)this.sprache.getString("sim_m41")), (Comparable)((Object)("B-V (" + d3 + " - " + d4 + ")")));
        this.dataset.addValue(list.get(2), (Comparable)((Object)this.sprache.getString("sim_m42")), (Comparable)((Object)("B-V (" + d3 + " - " + d4 + ")")));
        list = this.sonnenaehnlicheSterneDao.getAHSonnenaehnlicherSterne(d6, d5);
        this.dataset.addValue(list.get(0), (Comparable)((Object)this.sprache.getString("sim_m40")), (Comparable)((Object)(this.sprache.getString("db_m110") + " (" + d5 + " - " + d6 + ")")));
        this.dataset.addValue(list.get(1), (Comparable)((Object)this.sprache.getString("sim_m41")), (Comparable)((Object)(this.sprache.getString("db_m110") + " (" + d5 + " - " + d6 + ")")));
        this.dataset.addValue(list.get(2), (Comparable)((Object)this.sprache.getString("sim_m42")), (Comparable)((Object)(this.sprache.getString("db_m110") + " (" + d5 + " - " + d6 + ")")));
        list = this.sonnenaehnlicheSterneDao.getMetalSonnenaehnlicherSterne(d8, d7);
        this.dataset.addValue(list.get(0), (Comparable)((Object)this.sprache.getString("sim_m40")), (Comparable)((Object)("Fe/H (" + d7 + " - " + d8 + ")")));
        this.dataset.addValue(list.get(1), (Comparable)((Object)this.sprache.getString("sim_m41")), (Comparable)((Object)("Fe/H (" + d7 + " - " + d8 + ")")));
        this.dataset.addValue(list.get(2), (Comparable)((Object)this.sprache.getString("sim_m42")), (Comparable)((Object)("Fe/H (" + d7 + " - " + d8 + ")")));
        list = this.sonnenaehnlicheSterneDao.getAlterSonnenaehnlicherSterne(d9, d10);
        this.dataset.addValue(list.get(0), (Comparable)((Object)this.sprache.getString("sim_m40")), (Comparable)((Object)(this.sprache.getString("db_m124") + " (" + d9 + " - " + d10 + ")")));
        this.dataset.addValue(list.get(1), (Comparable)((Object)this.sprache.getString("sim_m41")), (Comparable)((Object)(this.sprache.getString("db_m124") + " (" + d9 + " - " + d10 + ")")));
        this.dataset.addValue(list.get(2), (Comparable)((Object)this.sprache.getString("sim_m42")), (Comparable)((Object)(this.sprache.getString("db_m124") + " (" + d9 + " - " + d10 + ")")));
        SonnenaehnlicheSterneDto sonnenaehnlicheSterneDto = new SonnenaehnlicheSterneDto();
        sonnenaehnlicheSterneDto.setMasseMaximal(d2);
        sonnenaehnlicheSterneDto.setMasseMinimal(d);
        sonnenaehnlicheSterneDto.setBvMaximal(d4);
        sonnenaehnlicheSterneDto.setBvMinimal(d3);
        sonnenaehnlicheSterneDto.setAbsoluteHelligkeitMaximal(d6);
        sonnenaehnlicheSterneDto.setAbsoluteHelligkeitMinimal(d5);
        sonnenaehnlicheSterneDto.setMetalMaximal(d8);
        sonnenaehnlicheSterneDto.setMetalMinimal(d7);
        sonnenaehnlicheSterneDto.setAlterMaximal(d10);
        sonnenaehnlicheSterneDto.setAlterMinimal(d9);
        list = this.sonnenaehnlicheSterneDao.getSonnenaehnlicheSterne2(sonnenaehnlicheSterneDto);
        this.dataset.addValue(list.get(0), (Comparable)((Object)this.sprache.getString("sim_m40")), (Comparable)((Object)this.sprache.getString("sim_m43")));
        this.dataset.addValue(list.get(1), (Comparable)((Object)this.sprache.getString("sim_m41")), (Comparable)((Object)this.sprache.getString("sim_m43")));
        this.dataset.addValue(list.get(2), (Comparable)((Object)this.sprache.getString("sim_m42")), (Comparable)((Object)this.sprache.getString("sim_m43")));
        list = list.subList(3, list.size());
        ObjectNameDialogCreator objectNameDialogCreator = new ObjectNameDialogCreator(this.objektnamenRepository);
        objectNameDialogCreator.zeigeDialogMitObjektnamen(this.sprache.getString("sim_gui59"), list);
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(this.getChartName(), this.sprache.getString("sim_m85"), this.sprache.getString("sim_m54"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui59");
    }

    @Override
    public String getChartKey() {
        return "sim_gui59";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("sim_gui49");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STATISTIK_ANZAHL_SONNEN;
    }
}

