/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.statistik;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IKategorienRepository;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class NumberOfTypesOfStarsChart
implements IChart {
    private final ISprachcontainer i18n;
    private final ISterneDAO sterneDAO;
    private final IDatenbankService datenbankService;
    private DefaultCategoryDataset dataset;
    private final IKategorienRepository kategorienRepository;
    private String title;

    @Inject
    public NumberOfTypesOfStarsChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO, IDatenbankService iDatenbankService, IKategorienRepository iKategorienRepository) {
        this.sterneDAO = iSterneDAO;
        this.datenbankService = iDatenbankService;
        this.kategorienRepository = iKategorienRepository;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        int n = this.kategorienRepository.getAnzahl(ObjektKategorie.STERNE.getKategorienName());
        this.title = this.getChartName() + " (" + this.i18n.toLocalisedInt(n) + " " + this.i18n.getString("sim_m47") + ")";
        List<String> list = this.datenbankService.getObjekttypen(ObjektKategorie.STERNE.getKategorienName());
        for (int i = 0; i < list.size(); ++i) {
            int n2 = this.sterneDAO.getAnzahlSterntypen(list.get(i));
            if (n2 == -1) {
                n2 = 0;
            }
            String string = this.i18n.getUebersetzungFuerAktuelleSprache(list.get(i));
            double d = (double)Math.round((double)n2 * 1000.0 / (double)n) / 10.0;
            this.dataset.addValue(n2, (Comparable)((Object)(string + " (" + this.i18n.toLocalisedDouble(d) + "%)")), (Comparable)((Object)""));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.title, this.i18n.getString("sim_m55"), this.i18n.getString("sim_m54"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui50");
    }

    @Override
    public String getChartKey() {
        return "sim_gui50";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("sim_gui49");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STATISTIK_ANZAHL_STERN_TYPEN;
    }
}

