/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.statistik;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.statistik.MilchstrassenRepository;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class PlanetenInDerMilchstrasse
implements IChart {
    private final ISprachcontainer i18n;
    private final MilchstrassenRepository repository;
    private DefaultCategoryDataset dataset;
    private String title;

    @Inject
    public PlanetenInDerMilchstrasse(IChartRepository iChartRepository, MilchstrassenRepository milchstrassenRepository) {
        this.repository = milchstrassenRepository;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        long l;
        this.dataset = new DefaultCategoryDataset();
        long l2 = l = this.repository.getAnzahlPlaneten() / 1000000L;
        this.title = this.getChartName() + " (" + this.i18n.toLocalisedNumber(l2) + " " + this.i18n.getString("sim_gui167") + ")";
        l = this.repository.getAnzahlPlanetenUmSonnenaehnlicheSterne() / 1000000L;
        double d = (double)Math.round((double)l * 10000.0 / (double)l2) / 100.0;
        this.dataset.addValue(l, (Comparable)((Object)(this.i18n.getString("sim_gui160") + " (" + this.i18n.toLocalisedDouble(d) + "%)")), (Comparable)((Object)""));
        l = this.repository.getAnzahlPlanetenInHabitablerZone() / 1000000L;
        d = (double)Math.round((double)l * 10000.0 / (double)l2) / 100.0;
        this.dataset.addValue(l, (Comparable)((Object)(this.i18n.getString("sim_gui161") + " (" + this.i18n.toLocalisedDouble(d) + "%)")), (Comparable)((Object)""));
        l = this.repository.getAnzahlPlanetenInHabitablerZoneUmSonnenaehnlicheSterne() / 1000000L;
        d = (double)Math.round((double)l * 10000.0 / (double)l2) / 100.0;
        this.dataset.addValue(l, (Comparable)((Object)(this.i18n.getString("sim_gui162") + " (" + this.i18n.toLocalisedDouble(d) + "%)")), (Comparable)((Object)""));
        l = this.repository.getAnzahlFelsplaneten() / 1000000L;
        d = (double)Math.round((double)l * 10000.0 / (double)l2) / 100.0;
        this.dataset.addValue(l, (Comparable)((Object)(this.i18n.getString("sim_gui163") + " (" + this.i18n.toLocalisedDouble(d) + "%)")), (Comparable)((Object)""));
        l = this.repository.getAnzahlFelsplanetenUmSonnenaehnlicheSterne() / 1000000L;
        d = (double)Math.round((double)l * 10000.0 / (double)l2) / 100.0;
        this.dataset.addValue(l, (Comparable)((Object)(this.i18n.getString("sim_gui164") + " (" + this.i18n.toLocalisedDouble(d) + "%)")), (Comparable)((Object)""));
        l = this.repository.getAnzahlFelsplanetenInHabitablerZone() / 1000000L;
        d = (double)Math.round((double)l * 10000.0 / (double)l2) / 100.0;
        this.dataset.addValue(l, (Comparable)((Object)(this.i18n.getString("sim_gui165") + " (" + this.i18n.toLocalisedDouble(d) + "%)")), (Comparable)((Object)""));
        l = this.repository.getAnzahlFelsplanetenInHabitablerZoneUmSonnenaehnlicheSterne() / 1000000L;
        d = (double)Math.round((double)l * 10000.0 / (double)l2) / 100.0;
        this.dataset.addValue(l, (Comparable)((Object)(this.i18n.getString("sim_gui166") + " (" + this.i18n.toLocalisedDouble(d) + "%)")), (Comparable)((Object)""));
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.title, "", this.i18n.getString("sim_gui158"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui157");
    }

    @Override
    public String getChartKey() {
        return "sim_gui157";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("sim_gui49");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STATISTIK_PLANETEN_MILCHSTRASSE;
    }
}

