/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.statistik;

import com.google.inject.Inject;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.statistik.ISonnensystemeRepository;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JPanel;
import org.apache.commons.lang3.tuple.Pair;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class Planetentypen
implements IChart {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final ISprachcontainer i18n;
    private final ISonnensystemeRepository repository;
    private DefaultCategoryDataset dataset;
    private String title;

    @Inject
    public Planetentypen(IChartRepository iChartRepository, ISonnensystemeRepository iSonnensystemeRepository) {
        this.repository = iSonnensystemeRepository;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        ArrayList<Callable<Pair>> arrayList = new ArrayList<Callable<Pair>>();
        arrayList.add(() -> Pair.of("sim_gui195", this.repository.getAnzahlBestaetigterExoplaneten()));
        arrayList.add(() -> Pair.of("sim_gui213", this.repository.getNumberOfExoplanetsWithUnknownRadius()));
        arrayList.add(() -> Pair.of("sim_gui144", this.repository.getNumberOfJoviansByRadius()));
        arrayList.add(() -> Pair.of("sim_gui147", this.repository.getNumberOfNeptunesByRadius()));
        arrayList.add(() -> Pair.of("sim_gui181", this.repository.getNumberOfMiniNeptunesByRadius()));
        arrayList.add(() -> Pair.of("sim_gui143", this.repository.getNumberOfSuperEarthsByRadius()));
        arrayList.add(() -> Pair.of("sim_gui149", this.repository.getNumberOfEarthsByRadius()));
        arrayList.add(() -> Pair.of("sim_gui148", this.repository.getNumberOfMiniEarthsByRadius()));
        arrayList.add(() -> Pair.of("sim_gui180", this.repository.getNumberOfMesoplanetsByRadius()));
        arrayList.add(() -> Pair.of("sim_m117", this.repository.getNumberOfPlanemos()));
        try {
            ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            List<Future<Future>> list = executorService.invokeAll(arrayList);
            executorService.shutdown();
            HashMap hashMap = new HashMap();
            list.forEach(future -> {
                try {
                    Pair pair = (Pair)future.get();
                    hashMap.put((String)pair.getLeft(), (Integer)pair.getRight());
                }
                catch (InterruptedException | ExecutionException exception) {
                    this.logger.error(exception);
                }
            });
            executorService.shutdownNow();
            int n = (Integer)hashMap.get("sim_gui195");
            this.title = this.getChartName() + " (" + this.i18n.toLocalisedInt(n) + " " + this.i18n.getString("sim_gui159") + ")";
            int n2 = (Integer)hashMap.get("sim_gui144");
            this.dataset.addValue(n2, (Comparable)((Object)(this.i18n.getString("sim_gui144") + " (" + this.getPercentFormatted(n2, n) + ")")), (Comparable)((Object)""));
            n2 = (Integer)hashMap.get("sim_gui147");
            this.dataset.addValue(n2, (Comparable)((Object)(this.i18n.getString("sim_gui147") + " (" + this.getPercentFormatted(n2, n) + ")")), (Comparable)((Object)""));
            n2 = (Integer)hashMap.get("sim_gui181");
            this.dataset.addValue(n2, (Comparable)((Object)(this.i18n.getString("sim_gui181") + " (" + this.getPercentFormatted(n2, n) + ")")), (Comparable)((Object)""));
            n2 = (Integer)hashMap.get("sim_gui143");
            this.dataset.addValue(n2, (Comparable)((Object)(this.i18n.getString("sim_gui143") + " (" + this.getPercentFormatted(n2, n) + ")")), (Comparable)((Object)""));
            n2 = (Integer)hashMap.get("sim_gui149");
            this.dataset.addValue(n2, (Comparable)((Object)(this.i18n.getString("sim_gui149") + " (" + this.getPercentFormatted(n2, n) + ")")), (Comparable)((Object)""));
            n2 = (Integer)hashMap.get("sim_gui148");
            this.dataset.addValue(n2, (Comparable)((Object)(this.i18n.getString("sim_gui148") + " (" + this.getPercentFormatted(n2, n) + ")")), (Comparable)((Object)""));
            n2 = (Integer)hashMap.get("sim_gui180");
            this.dataset.addValue(n2, (Comparable)((Object)(this.i18n.getString("sim_gui180") + " (" + this.getPercentFormatted(n2, n) + ")")), (Comparable)((Object)""));
            n2 = (Integer)hashMap.get("sim_m117");
            this.dataset.addValue(n2, (Comparable)((Object)(this.i18n.getString("sim_m117") + " (" + this.getPercentFormatted(n2, n) + ")")), (Comparable)((Object)""));
            n2 = (Integer)hashMap.get("sim_gui213");
            this.dataset.addValue(n2, (Comparable)((Object)(this.i18n.getString("sim_gui213") + " (" + this.getPercentFormatted(n2, n) + ")")), (Comparable)((Object)""));
        }
        catch (InterruptedException interruptedException) {
            this.logger.error(interruptedException);
        }
    }

    private String getPercentFormatted(int n, int n2) {
        return this.i18n.toLocalisedDouble((double)Math.round((double)n * 1000.0 / (double)n2) / 10.0) + "%";
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.title, "", this.i18n.getString("sim_gui195"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui140");
    }

    @Override
    public String getChartKey() {
        return "sim_gui140";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("sim_gui49");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STATISTIK_PLANETENTYPEN;
    }
}

