/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.statistik;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.statistik.ISonnensystemeRepository;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class Sonnensysteme
implements IChart {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final ISprachcontainer i18n;
    private final ISonnensystemeRepository repository;
    private DefaultCategoryDataset dataset;

    @Inject
    public Sonnensysteme(IChartRepository iChartRepository, ISonnensystemeRepository iSonnensystemeRepository) {
        this.repository = iSonnensystemeRepository;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        try {
            int n = this.repository.getAnzahlSterneMitExoPlaneten(false);
            int n2 = this.repository.getAnzahl(ObjektKategorie.STERNE);
            this.dataset.addValue(n, (Comparable)((Object)(this.i18n.getString("sim_m48") + " (" + this.i18n.toLocalisedDouble(100.0) + "% / " + this.i18n.toLocalisedDouble((double)Math.round((double)n * 10000.0 / (double)n2) / 100.0) + "%)")), (Comparable)((Object)""));
            int n3 = this.repository.getAnzahlEinzelsterneMitExoPlaneten();
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_m109") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getAnzahlMehrfachsterneMitExoplaneten();
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_m110") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getAnzahlSterneMitVielenPlaneten();
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_m111") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getAnzahlSterneMetalUndExoPlaneten();
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_m133") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getAnzahlSterneMitPlanetenInGruenerZone();
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_m50") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getSterneMitErdaehnlichenPlaneten(0.01);
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_m49") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getAnzahlSterneMitGasriesenInnen();
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_m112") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getAnzahlSterneMitGasriesenAussen();
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_m113") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getAnzahlSterneMitErdenInnen();
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_m114") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getAnzahlSterneMitErdenAussen();
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_m115") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getAnzahlSterneMitHotJupitern();
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_gui138") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getAnzahlSterneMitSupererden();
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_gui139") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getAnzahlSterneMitBraunenZwergen();
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_m118") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n2) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getAnzahlSterneMitBraunenZwergenUndPlaneten();
            this.dataset.addValue(n3, (Comparable)((Object)(this.i18n.getString("sim_m119") + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n3 * 10000.0 / (double)n2) / 100.0) + "%)")), (Comparable)((Object)""));
            n3 = this.repository.getAnzahlBrauneZwergeMitExoplaneten();
            this.dataset.addValue(n3, (Comparable)((Object)this.i18n.getString("sim_m116")), (Comparable)((Object)""));
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.getChartName(), "", this.i18n.getString("sim_m54"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui58");
    }

    @Override
    public String getChartKey() {
        return "sim_gui58";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("sim_gui49");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STATISTIK_SONNENSYSTEM;
    }
}

