/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.statistik;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class SpektraltypesOfStarsIn34LyChart
implements IChart {
    private final ISprachcontainer i18n;
    private final ISterneDAO sterneDAO;
    private final IDatenbankService datenbankService;
    private DefaultCategoryDataset dataset;
    private String title;

    @Inject
    public SpektraltypesOfStarsIn34LyChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO) {
        this.sterneDAO = iSterneDAO;
        this.datenbankService = BeanFactory.getInstance();
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        int n;
        this.dataset = new DefaultCategoryDataset();
        Map<String, Integer> map = this.sterneDAO.getUnbekannteSpektraltypenNachTemperatur(34.0);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        List<String> list = this.datenbankService.getSpektraltypen(ObjektKategorie.STERNE.getKategorienName());
        for (n = 0; n < list.size(); ++n) {
            int n3 = this.sterneDAO.getAnzahlSpektraltypenIn34Ly(list.get(n));
            if (list.get(n).equals("unbekannt")) {
                for (Integer n4 : map.values()) {
                    n3 -= n4.intValue();
                }
            } else {
                Integer n5 = map.get(list.get(n));
                if (n5 != null) {
                    n3 += n5.intValue();
                }
            }
            arrayList.add(n3);
            n2 += n3;
        }
        this.title = this.getChartName() + " (" + this.i18n.toLocalisedInt(n2) + " " + this.i18n.getString("sim_m47") + ")";
        if (n2 == 0) {
            return;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            Integer n6 = (Integer)arrayList.get(n);
            if (n6 <= 0) continue;
            this.dataset.addValue(n6, (Comparable)((Object)(list.get(n) + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)n6.intValue() * 1000.0 / (double)n2) / 10.0) + "%)")), (Comparable)((Object)"Sptyp"));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.title, this.i18n.getString("sim_m57"), this.i18n.getString("sim_m54"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui62");
    }

    @Override
    public String getChartKey() {
        return "sim_gui62";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("sim_gui49");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STATISTIK_SPTYPEN_IN_34_LY;
    }
}

