/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.statistik;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.lang3.tuple.Pair;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class StarTypesAndSpektraltypesOfStarsIn34LyChart
implements IChart {
    private final ISprachcontainer i18n;
    private final ISterneDAO sterneDAO;
    private final IDatenbankService datenbankService;
    private DefaultCategoryDataset dataset;
    private String title;

    @Inject
    public StarTypesAndSpektraltypesOfStarsIn34LyChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO) {
        this.sterneDAO = iSterneDAO;
        this.datenbankService = BeanFactory.getInstance();
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        int n = 0;
        List<String> list = this.datenbankService.getSpektraltypen(ObjektKategorie.STERNE.getKategorienName());
        ArrayList<Pair<String, Integer>> arrayList = new ArrayList<Pair<String, Integer>>();
        for (String object : list) {
            int n2 = this.sterneDAO.getNumberOfSptypesForDoubleAndMultipleStarsIn34ly(object);
            if (n2 <= 0) continue;
            n += n2;
            arrayList.add(Pair.of(object, n2));
        }
        this.title = this.getChartName() + " (" + this.i18n.toLocalisedInt(n) + " " + this.i18n.getString("sim_m47") + ")";
        for (Pair pair : arrayList) {
            this.dataset.addValue((Number)pair.getValue(), (Comparable)((Object)((String)pair.getKey() + " (" + this.i18n.toLocalisedDouble((double)Math.round((double)((Integer)pair.getValue()).intValue() * 1000.0 / (double)n) / 10.0) + "%)")), (Comparable)((Object)"Sptyp"));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.title, this.i18n.getString("sim_m57"), this.i18n.getString("sim_m54"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui212");
    }

    @Override
    public String getChartKey() {
        return "sim_gui212";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("sim_gui49");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STATISTIK_STERNTYPEN_SPTYPEN_IN_34_LY;
    }
}

