/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.statistik;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class StarTypesIn34LyChart
implements IChart {
    private final ISprachcontainer i18n;
    private final ISterneDAO sterneDAO;
    private final IDatenbankService datenbankService;
    private DefaultCategoryDataset dataset;
    private String title;

    @Inject
    public StarTypesIn34LyChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO) {
        this.sterneDAO = iSterneDAO;
        this.datenbankService = BeanFactory.getInstance();
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        int n;
        this.dataset = new DefaultCategoryDataset();
        int n2 = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        List<String> list = this.datenbankService.getObjekttypen(ObjektKategorie.STERNE.getKategorienName());
        for (String string : list) {
            n = this.sterneDAO.getAnzahlSterntypenIn34Ly(string);
            if (n == -1) {
                n = 0;
            }
            hashMap.put(string, n);
            n2 += n;
        }
        this.title = this.getChartName() + " (" + this.i18n.toLocalisedInt(n2) + " " + this.i18n.getString("sim_m47") + ")";
        for (String string : list) {
            n = (Integer)hashMap.get(string);
            if (n <= 0) continue;
            String string2 = this.i18n.getUebersetzungFuerAktuelleSprache(string);
            double d = (double)Math.round((double)n * 1000.0 / (double)n2) / 10.0;
            this.dataset.addValue(n, (Comparable)((Object)(string2 + " (" + this.i18n.toLocalisedDouble(d) + "%)")), (Comparable)((Object)""));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.title, this.i18n.getString("sim_m55"), this.i18n.getString("sim_m54"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui211");
    }

    @Override
    public String getChartKey() {
        return "sim_gui211";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("sim_gui49");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STATISTIK_SPTYPEN_IN_34_LY;
    }
}

