/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.sterne;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IDurchschnittsSternDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class AverageStarAgeChart
implements IChart {
    private final String restlicheSterneKey = "sim_m25";
    private final String sterneMitExoplanetenKey = "sim_m24";
    private final ISprachcontainer i18n;
    private final IDurchschnittsSternDAO durchschnittsSternDAO;
    private DefaultCategoryDataset dataset;

    @Inject
    public AverageStarAgeChart(IChartRepository iChartRepository, IDurchschnittsSternDAO iDurchschnittsSternDAO) {
        this.durchschnittsSternDAO = iDurchschnittsSternDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        this.dataset.addValue(this.durchschnittsSternDAO.getDurchschnittssternAlter(true), (Comparable)((Object)this.i18n.getString("sim_m24")), (Comparable)((Object)""));
        this.dataset.addValue(this.durchschnittsSternDAO.getDurchschnittssternAlter(false), (Comparable)((Object)this.i18n.getString("sim_m25")), (Comparable)((Object)""));
        this.dataset.addValue(4.5, (Comparable)((Object)(this.i18n.getString("sim_m103") + " (" + this.i18n.toLocalisedDouble(4.5) + ")")), (Comparable)((Object)""));
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.getChartName(), "", this.i18n.getString("sim_m86"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui94") + " " + this.i18n.getString("db_m124");
    }

    @Override
    public String getChartKey() {
        return "sim_gui94";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_sterne");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STERNE_DURCHNSCHNITT_ALTER;
    }
}

