/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.sterne;

import com.google.common.io.Files;
import com.google.inject.Inject;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.IDAOhigh;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.simulationen.diagramme.util.SptypDoubleKonverter;
import de.planetensuche.simulationen.diagramme.util.SptypFarbKonverter;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class DistanceAndSptypChart
extends JPanel
implements IChart {
    private final ISprachcontainer i18n = SprachcontainerFabrik.getSprachcontainer();
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final IDAOhigh daoHigh;
    private final int screenx;
    private final int screeny;
    private final int stepx;
    private final int stepy;
    private boolean zeigeSterneMitNamen;
    private List<String> daten;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;

    @Inject
    public DistanceAndSptypChart(IChartRepository iChartRepository, IDAOhigh iDAOhigh, IPlanetensucheObjektRepository iPlanetensucheObjektRepository, IObjektnamenRepository iObjektnamenRepository) {
        this.daoHigh = iDAOhigh;
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.objektnamenRepository = iObjektnamenRepository;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.screenx = (int)((double)dimension.width * 0.8) - 275;
        this.screeny = (int)((double)dimension.height * 0.8) - 105;
        this.setBounds(0, 0, this.screenx + 275, this.screeny + 75);
        this.setPreferredSize(new Dimension(this.screenx + 275, this.screeny + 75));
        this.stepx = (this.screenx - 70) / 7;
        this.stepy = (this.screeny - 50) / 10;
        this.setBackground(Color.black);
        iChartRepository.register(this);
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        super.paint(graphics);
        if (this.daten == null) {
            return;
        }
        SptypFarbKonverter sptypFarbKonverter = new SptypFarbKonverter();
        graphics.setColor(Color.WHITE);
        graphics.setFont(new Font("Serif", 1, 16));
        this.zeichneLegende(graphics, sptypFarbKonverter);
        graphics.setColor(Color.WHITE);
        graphics.drawLine(50, this.screeny, this.screenx, this.screeny);
        graphics.drawString(this.i18n.getString("sim_gui70"), this.screenx / 2, this.screeny + 45);
        String[] stringArray = new String[]{"O", "B", "A", "F", "G", "K", "M"};
        for (n4 = 0; n4 < 7; ++n4) {
            graphics.drawLine(50 + n4 * this.stepx, this.screeny, 50 + n4 * this.stepx, this.screeny + 10);
            graphics.drawString(stringArray[n4], 50 + n4 * this.stepx, this.screeny + 25);
        }
        graphics.drawLine(50 + 7 * this.stepx - this.stepx / 10, this.screeny, 50 + 7 * this.stepx - this.stepx / 10, this.screeny + 10);
        graphics.drawString("M9", 50 + 7 * this.stepx - this.stepx / 10, this.screeny + 25);
        for (n4 = 0; n4 < 7; ++n4) {
            graphics.drawLine(50 + this.stepx / 2 + this.stepx * n4, this.screeny, 50 + this.stepx / 2 + this.stepx * n4, this.screeny + 5);
        }
        graphics.drawLine(50, 0, 50, this.screeny);
        graphics.drawString(this.i18n.getString("sim_gui79"), 10, 20);
        graphics.drawString(this.i18n.getString("sim_gui80"), 10, 35);
        String[] stringArray2 = new String[]{"1000", "900", "800", "700", "600", "500", "400", "300", "200", "100", "0"};
        for (n3 = 10; n3 > -1; --n3) {
            graphics.drawLine(50, this.screeny - n3 * this.stepy, 40, this.screeny - n3 * this.stepy);
            int n5 = 15;
            if (stringArray2[10 - n3].length() == 2) {
                n5 = 20;
            } else if (stringArray2[10 - n3].length() == 1) {
                n5 = 30;
            }
            graphics.drawString(stringArray2[10 - n3], n5, this.screeny - n3 * this.stepy);
        }
        for (n3 = 9; n3 > -1; --n3) {
            graphics.drawLine(50, this.screeny - (n3 * this.stepy + this.stepy / 2), 45, this.screeny - (n3 * this.stepy + this.stepy / 2));
        }
        try {
            for (String object2 : this.daten) {
                String[] stringArray3 = object2.split(";");
                double d2 = Double.parseDouble(stringArray3[0]);
                d = Double.parseDouble(stringArray3[1]);
                graphics.setColor(sptypFarbKonverter.getColorForSptyp(d));
                d = 50.0 + (double)this.stepx * (d / 10.0);
                d2 = (double)this.screeny - (double)this.stepy / 100.0 * d2;
                n2 = (int)Math.round(d2);
                n = (int)Math.round(d);
                graphics.fillOval(n, n2, 2, 2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logging.error(numberFormatException);
        }
        if (this.zeigeSterneMitNamen) {
            graphics.setColor(Color.WHITE);
            try {
                SptypDoubleKonverter sptypDoubleKonverter = new SptypDoubleKonverter();
                List<String> list = Files.readLines(new File("sterne3.txt"), Charset.forName("UTF-8"));
                for (String string : list) {
                    try {
                        String[] exception;
                        Integer n5;
                        if (string.startsWith("//") || (n5 = this.objektnamenRepository.getIDFuerNamen((exception = string.split(","))[0], true)) == null) continue;
                        IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(n5);
                        char c = iPlanetensucheObjekt.getSpektralklasse().charAt(0);
                        d = sptypDoubleKonverter.getDoubleForSptyp(c);
                        d += iPlanetensucheObjekt.getSpektralklasse2();
                        double d2 = iPlanetensucheObjekt.getEntfernung();
                        d = 50.0 + (double)this.stepx * (d / 10.0);
                        d2 = (double)this.screeny - (double)this.stepy / 100.0 * d2;
                        n2 = (int)Math.round(d2);
                        n = (int)Math.round(d);
                        graphics.drawOval(n - 10, n2 - 10, 20, 20);
                        graphics.drawString(exception[0], n + 10, n2 + 5);
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException | SQLException exception) {
                        this.logging.error(exception);
                    }
                }
            }
            catch (IOException iOException) {
                this.logging.error(iOException);
                this.logging.showErrorMessageBox(null, this.i18n.getString("sim_f2") + "\n" + iOException.toString(), this.i18n.getString("sim_f2_titel"));
            }
        }
    }

    private void zeichneLegende(Graphics graphics, SptypFarbKonverter sptypFarbKonverter) {
        graphics.drawString(this.i18n.getString("sim_gui70"), this.screenx, 50);
        graphics.drawString(this.i18n.getString("sim_gui71"), this.screenx, 75);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("O"));
        graphics.drawString("O - " + this.i18n.getString("sim_gui72") + " (>" + this.i18n.toLocalisedInt(25000) + "K)", this.screenx, 100);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("B"));
        graphics.drawString("B - " + this.i18n.getString("sim_gui73") + " (" + this.i18n.toLocalisedInt(10000) + "-" + this.i18n.toLocalisedInt(25000) + "K)", this.screenx, 125);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("A"));
        graphics.drawString("A - " + this.i18n.getString("sim_gui74") + " (" + this.i18n.toLocalisedInt(7600) + "-" + this.i18n.toLocalisedInt(10000) + "K)", this.screenx, 150);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("F"));
        graphics.drawString("F - " + this.i18n.getString("sim_gui75") + " (" + this.i18n.toLocalisedInt(6000) + "-" + this.i18n.toLocalisedInt(7600) + "K)", this.screenx, 175);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("G"));
        graphics.drawString("G - " + this.i18n.getString("sim_gui76") + " (" + this.i18n.toLocalisedInt(5100) + "-" + this.i18n.toLocalisedInt(6000) + "K)", this.screenx, 200);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("K"));
        graphics.drawString("K - " + this.i18n.getString("sim_gui77") + " (" + this.i18n.toLocalisedInt(3600) + "-" + this.i18n.toLocalisedInt(5100) + "K)", this.screenx, 225);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("M"));
        graphics.drawString("M - " + this.i18n.getString("sim_gui78") + " (" + this.i18n.toLocalisedInt(2500) + "-" + this.i18n.toLocalisedInt(3600) + "K)", this.screenx, 250);
    }

    @Override
    public void beforeCollectData() {
        int n = JOptionPane.showConfirmDialog(null, this.i18n.getString("sim_m8"), this.i18n.getString("sim_m8_titel"), 0);
        if (n == 0) {
            this.zeigeSterneMitNamen = true;
        }
    }

    @Override
    public void collectData() throws SQLException {
        this.daten = this.daoHigh.getSterneMitEntfernung(1000.0);
    }

    @Override
    public JPanel createChart() {
        return this;
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui29");
    }

    @Override
    public String getChartKey() {
        return "sim_gui29";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_sterne");
    }

    @Override
    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STERNE_ENTFERNUNG_SPTYP;
    }
}

