/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.sterne;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeriesCollection;

public final class DistanceAndStarTypeChart
implements IChart {
    private final ISprachcontainer sprache;
    private final DiagrammHelfer helfer;
    private final ISterneDAO sterneDAO;
    private final IDatenbankService datenbankService;
    private XYSeriesCollection collection;
    private double maxEntfernung;

    @Inject
    public DistanceAndStarTypeChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO, IDatenbankService iDatenbankService) {
        this.sterneDAO = iSterneDAO;
        this.datenbankService = iDatenbankService;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.sprache);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
        this.maxEntfernung = this.helfer.zeigeEingabeDialog(null, this.sprache.getString("sim_m9"), this.sprache.getString("ps_sterne"), 500.0, "ly", 5.0, new double[0]);
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        List<String> list = this.datenbankService.getObjekttypen(ObjektKategorie.STERNE.getKategorienName());
        for (int i = 0; i < list.size(); ++i) {
            String string = this.sprache.getUebersetzungFuerAktuelleSprache(list.get(i));
            this.helfer.fuelleCollection(this.collection, string, this.sterneDAO.getEntfernungUndHelligkeit(list.get(i), this.maxEntfernung));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("sim_m68"), this.sprache.getString("sim_m71"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui30");
    }

    @Override
    public String getChartKey() {
        return "sim_gui30";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_sterne");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STERNE_ENTFERNUNG_STERNTYP;
    }
}

