/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.sterne;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneGaiaDataDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.simulationen.diagramme.util.MedianCalculator;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class EbsAstroExNoiseSigVmagChart
implements IChart {
    private final ISprachcontainer i18n;
    private final ISterneGaiaDataDAO starsDao;
    private XYSeriesCollection collection;
    private double medianAens;

    @Inject
    public EbsAstroExNoiseSigVmagChart(IChartRepository iChartRepository, ISterneGaiaDataDAO iSterneGaiaDataDAO) {
        this.starsDao = iSterneGaiaDataDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        List<ErgebnisXYDto> list = this.starsDao.getAstroExNoiseSigAndVmagForAll(StarObjectType.ECLIPSING_BINARY);
        XYSeries xYSeries = new XYSeries((Comparable)((Object)(this.i18n.getString("sim_m172") + " (" + this.i18n.toLocalisedInt(list.size()) + ")")));
        for (ErgebnisXYDto ergebnisXYDto : list) {
            xYSeries.add(ergebnisXYDto.getX(), ergebnisXYDto.getY());
            arrayList.add(ergebnisXYDto.getY());
        }
        this.collection.addSeries(xYSeries);
        this.medianAens = MedianCalculator.calculateMedian(arrayList);
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.i18n.getString("sim_gui205"), this.i18n.getString("sim_m169"), this.i18n.getString("sim_m171"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        ValueMarker valueMarker = new ValueMarker(this.medianAens);
        valueMarker.setPaint(Color.black);
        xYPlot.addRangeMarker(valueMarker);
        LegendItemCollection legendItemCollection = xYPlot.getLegendItems();
        LegendItem legendItem = new LegendItem(this.i18n.getString("sim_m179", this.medianAens));
        legendItemCollection.add(legendItem);
        xYPlot.setFixedLegendItems(legendItemCollection);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui204");
    }

    @Override
    public String getChartKey() {
        return "sim_gui204";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_sterne");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STERNE_EB_ASTRO_EX_NOISE_SIG_VMAG;
    }
}

