/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.sterne;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public final class EbsRadiusTemperaturChart
implements IChart {
    private final ISprachcontainer i18n;
    private final ISterneDAO starsDao;
    private XYSeriesCollection collection;

    @Inject
    public EbsRadiusTemperaturChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO) {
        this.starsDao = iSterneDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        List<ErgebnisXYDto> list = this.starsDao.getTemperaturAndRadiusForEbs();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)(this.i18n.getString("sim_m172") + " (" + this.i18n.toLocalisedInt(list.size()) + ")")));
        for (ErgebnisXYDto ergebnisXYDto : list) {
            xYSeries.add(ergebnisXYDto.getX(), ergebnisXYDto.getY());
        }
        this.collection.addSeries(xYSeries);
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.i18n.getString("sim_gui184"), this.i18n.getString("sim_m173"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui206");
    }

    @Override
    public String getChartKey() {
        return "sim_gui206";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_sterne");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STERNE_EB_RADIUS_TEMPERATUR;
    }
}

