/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.sterne;

import com.google.common.io.Files;
import com.google.inject.Inject;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.GuiDesignerFabrik;
import de.planetensuche.guidesigner.IGuiDesigner;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.api.IFHDDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IDurchschnittsSternDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISternhaufenDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.simulationen.diagramme.sterne.LeuchtkraftklassenZeichner;
import de.planetensuche.simulationen.diagramme.util.SptypFarbKonverter;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class FhdChart
extends JPanel
implements IChart {
    private final ILogging logging;
    private final ISprachcontainer i18n;
    private final IGuiDesigner guiDesigner;
    private final IFHDDAO fhdDoa;
    private final IDurchschnittsSternDAO durchschnittsSternDAO;
    private final ISternhaufenDAO sternhaufenDAO;
    private final LeuchtkraftklassenZeichner leuchtkraftklassenZeichner;
    private final int screenx;
    private final int screeny;
    private final int stepx;
    private final int stepy;
    private boolean zeigeSterneMitNamen;
    private boolean zeigeLeuchtkraftklassen;
    private String sternhaufenName;
    private List<ErgebnisXYDto> sterneDtos;
    private final String[] yLabel = new String[]{"-10", "-5", "0", "5", "10", "15", "20", "25", "30"};
    private final String[] xLabel = new String[]{"-2,0", "-1,0", "0,0", "1,0", "2,0", "3,0", "4,0", "4,5", "5,0"};
    private final double absmagNull;
    private final double bvNull;
    private List<String> lks;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;

    @Inject
    public FhdChart(IChartRepository iChartRepository, IFHDDAO iFHDDAO, IDurchschnittsSternDAO iDurchschnittsSternDAO, ISternhaufenDAO iSternhaufenDAO, IDatenbankService iDatenbankService, IPlanetensucheObjektRepository iPlanetensucheObjektRepository, IObjektnamenRepository iObjektnamenRepository) {
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.guiDesigner = GuiDesignerFabrik.getInstance();
        this.fhdDoa = iFHDDAO;
        this.durchschnittsSternDAO = iDurchschnittsSternDAO;
        this.sternhaufenDAO = iSternhaufenDAO;
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.objektnamenRepository = iObjektnamenRepository;
        this.logging = LoggingFactory.getLoggerForClass(FhdChart.class);
        this.leuchtkraftklassenZeichner = new LeuchtkraftklassenZeichner(this.i18n);
        this.sterneDtos = new ArrayList<ErgebnisXYDto>();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.screenx = (int)((double)dimension.width * 0.8) - 275;
        this.screeny = (int)((double)dimension.height * 0.8) - 75;
        this.setBounds(0, 0, this.screenx + 275, this.screeny + 75);
        this.setPreferredSize(new Dimension(this.screenx + 275, this.screeny + 75));
        this.stepx = (this.screenx - 70) / this.xLabel.length;
        this.stepy = (this.screeny - 70) / this.yLabel.length;
        this.absmagNull = (double)this.screeny - 50.0 - ((double)this.yLabel.length - 3.0) * (double)this.stepy;
        this.bvNull = 50.0 + 2.0 * (double)this.stepx;
        try {
            List<String> list = iDatenbankService.getLeuchtkraftklassen();
            this.lks = new ArrayList<String>(list);
            this.lks.remove("unbekannt");
        }
        catch (SQLException sQLException) {
            this.logging.error(sQLException);
        }
        iChartRepository.register(this);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.sterneDtos.isEmpty()) {
            return;
        }
        graphics.setFont(this.guiDesigner.getFont(false));
        graphics.setColor(Color.WHITE);
        this.paintBVIndexLegende(graphics);
        if (this.zeigeLeuchtkraftklassen) {
            this.leuchtkraftklassenZeichner.paintLeuchtkraftklassenLegende(graphics, this.screenx);
        }
        this.paintXAchse(graphics);
        this.paintYAchse(graphics);
        graphics.setColor(new Color(255, 255, 255));
        try {
            this.paintSterne(graphics);
        }
        catch (NumberFormatException numberFormatException) {
            this.logging.error(numberFormatException);
        }
        if (this.zeigeLeuchtkraftklassen) {
            this.paintLeuchtkraftklassen(graphics);
        }
        if (this.zeigeSterneMitNamen) {
            this.paintSternnamenBeispielsterne(graphics);
        }
    }

    private void paintSternnamenBeispielsterne(Graphics graphics) {
        graphics.setColor(Color.YELLOW);
        try {
            List<String> list = Files.readLines(new File("sterne2.txt"), Charset.forName("UTF-8"));
            for (String string : list) {
                try {
                    String[] stringArray;
                    Integer n;
                    if (string.startsWith("//") || (n = this.objektnamenRepository.getIDFuerNamen((stringArray = string.split(","))[0], true)) == null) continue;
                    IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(n);
                    double d = iPlanetensucheObjekt.getBV();
                    double d2 = iPlanetensucheObjekt.getAbsoluteHelligkeit();
                    if (!(d2 >= -15.0) || !(d2 <= 35.0) || !(d >= -2.0) || !(d <= 5.0)) continue;
                    d2 = d2 > 0.0 ? this.absmagNull + d2 / 5.0 * (double)this.stepy : (d2 < 0.0 ? this.absmagNull - d2 * -1.0 / 5.0 * (double)this.stepy : this.absmagNull);
                    d = d > 0.0 ? this.bvNull + (double)this.stepx * d : (d < 0.0 ? this.bvNull - (double)this.stepx * (d * -1.0) : this.bvNull);
                    int n2 = (int)Math.round(d2);
                    int n3 = (int)Math.round(d);
                    graphics.drawOval(n3 - 10, n2 - 10, 20, 20);
                    graphics.drawString(stringArray[0], n3 + 10, n2 + 5);
                }
                catch (NumberFormatException | SQLException exception) {
                    this.logging.error(exception);
                }
            }
        }
        catch (IOException iOException) {
            this.logging.error(iOException);
            this.logging.showErrorMessageBox(null, this.i18n.getString("sim_f2") + "\n" + iOException.toString(), this.i18n.getString("sim_f2_titel"));
        }
    }

    private void paintLeuchtkraftklassen(Graphics graphics) {
        graphics.setColor(Color.RED);
        for (String string : this.lks) {
            int n = 0;
            int n2 = 0;
            double d = -2.0;
            if ("V".equals(string)) {
                d = -0.25;
            } else if ("VI".equals(string)) {
                d = 1.4;
            }
            for (double d2 = d; !(!(d2 < 5.2) || "V".equals(string) && d2 > 1.4); d2 += 0.1) {
                double d3 = this.durchschnittsSternDAO.getDurchschnittAHFuerBVUndLK(d2, string);
                if (!(d3 > -100.0)) continue;
                double d4 = d3;
                double d5 = d2;
                d4 = d4 > 0.0 ? this.absmagNull + d4 / 5.0 * (double)this.stepy : (d4 < 0.0 ? this.absmagNull - d4 * -1.0 / 5.0 * (double)this.stepy : this.absmagNull);
                d5 = d5 > 0.0 ? this.bvNull + (double)this.stepx * d5 : (d5 < 0.0 ? this.bvNull - (double)this.stepx * (d5 * -1.0) : this.bvNull);
                if (n == 0) {
                    n = (int)Math.round(d5);
                    n2 = (int)Math.round(d4);
                    continue;
                }
                graphics.drawLine(n, n2, (int)Math.round(d5), (int)Math.round(d4));
                n = (int)Math.round(d5);
                n2 = (int)Math.round(d4);
            }
            graphics.drawString(string, n, n2);
        }
    }

    private void paintSterne(Graphics graphics) {
        for (ErgebnisXYDto ergebnisXYDto : this.sterneDtos) {
            double d = ergebnisXYDto.getX();
            double d2 = ergebnisXYDto.getY();
            if (!(d2 >= -16.0) || !(d2 <= 36.0) || !(d >= -2.0) || !(d <= 5.5)) continue;
            d2 = d2 > 0.0 ? this.absmagNull + d2 / 5.0 * (double)this.stepy : (d2 < 0.0 ? this.absmagNull - d2 * -1.0 / 5.0 * (double)this.stepy : this.absmagNull);
            d = d > 0.0 ? this.bvNull + (double)this.stepx * d : (d < 0.0 ? this.bvNull - (double)this.stepx * (d * -1.0) : this.bvNull);
            graphics.fillOval((int)Math.round(d), (int)Math.round(d2), 2, 2);
        }
    }

    private void paintYAchse(Graphics graphics) {
        int n;
        graphics.drawLine(50, 0, 50, this.screeny);
        graphics.drawString(this.i18n.getString("db_m110"), 10, 50);
        graphics.drawString("in mag", 10, 65);
        for (n = this.yLabel.length - 1; n > -1; --n) {
            graphics.drawLine(50, this.screeny - 50 - n * this.stepy, 40, this.screeny - 50 - n * this.stepy);
            int n2 = 20;
            if (this.yLabel[this.yLabel.length - 1 - n].length() == 2) {
                n2 = 25;
            } else if (this.yLabel[this.yLabel.length - 1 - n].length() == 1) {
                n2 = 35;
            }
            graphics.drawString(this.yLabel[this.yLabel.length - 1 - n], n2, this.screeny - 50 - n * this.stepy);
        }
        for (n = this.yLabel.length - 1; n > -1; --n) {
            graphics.drawLine(50, this.screeny - 50 - (n * this.stepy + this.stepy / 2), 45, this.screeny - 50 - (n * this.stepy + this.stepy / 2));
        }
    }

    private void paintXAchse(Graphics graphics) {
        int n;
        graphics.drawLine(50, this.screeny, this.stepx * this.xLabel.length, this.screeny);
        graphics.drawString("B-V (" + this.i18n.getString("sim_m96") + ")", this.stepx * this.xLabel.length, this.screeny + 25);
        for (n = 0; n < this.xLabel.length; ++n) {
            graphics.drawLine(50 + n * this.stepx, this.screeny, 50 + n * this.stepx, this.screeny + 10);
            graphics.drawString(this.xLabel[n], 50 + n * this.stepx, this.screeny + 25);
        }
        for (n = 0; n < this.xLabel.length - 1; ++n) {
            graphics.drawLine(50 + this.stepx / 2 + this.stepx * n, this.screeny, 50 + this.stepx / 2 + this.stepx * n, this.screeny + 5);
        }
    }

    private void paintBVIndexLegende(Graphics graphics) {
        SptypFarbKonverter sptypFarbKonverter = new SptypFarbKonverter();
        String string = "B-V " + this.i18n.getString("sim_m96") + " (" + this.i18n.toLocalisedNumber(this.sterneDtos.size()) + " " + this.i18n.getString("sim_m47") + ")";
        graphics.drawString(string, this.screenx, 50);
        graphics.drawString(this.i18n.getString("sim_gui71"), this.screenx, 75);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("O"));
        graphics.drawString("O - " + this.i18n.getString("sim_gui72") + " (<" + this.i18n.toLocalisedDouble(0.0) + ")", this.screenx, 100);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("B"));
        graphics.drawString("B - " + this.i18n.getString("sim_gui73") + " (" + this.i18n.toLocalisedDouble(-0.2) + " - " + this.i18n.toLocalisedDouble(0.1) + ")", this.screenx, 125);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("A"));
        graphics.drawString("A - " + this.i18n.getString("sim_gui74") + " (" + this.i18n.toLocalisedDouble(0.0) + " - " + this.i18n.toLocalisedDouble(0.3) + ")", this.screenx, 150);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("F"));
        graphics.drawString("F - " + this.i18n.getString("sim_gui75") + " (" + this.i18n.toLocalisedDouble(0.3) + " - " + this.i18n.toLocalisedDouble(0.7) + ")", this.screenx, 175);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("G"));
        graphics.drawString("G - " + this.i18n.getString("sim_gui76") + " (" + this.i18n.toLocalisedDouble(0.5) + " - " + this.i18n.toLocalisedDouble(1.2) + ")", this.screenx, 200);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("K"));
        graphics.drawString("K - " + this.i18n.getString("sim_gui77") + " (" + this.i18n.toLocalisedDouble(0.9) + " - " + this.i18n.toLocalisedDouble(2.0) + ")", this.screenx, 225);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("M"));
        graphics.drawString("M - " + this.i18n.getString("sim_gui78") + " (" + this.i18n.toLocalisedDouble(1.4) + " - " + this.i18n.toLocalisedDouble(2.5) + ")", this.screenx, 250);
        graphics.setColor(Color.WHITE);
        graphics.drawString(this.i18n.getString("ps_br_zwerge") + ":", this.screenx, 300);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("L"));
        graphics.drawString("L, T, Y - " + this.i18n.getString("sim_gui78") + " (>" + this.i18n.toLocalisedDouble(1.2) + ")", this.screenx, 325);
    }

    @Override
    public void beforeCollectData() {
        int n;
        this.zeigeSterneMitNamen = false;
        this.zeigeLeuchtkraftklassen = false;
        this.sternhaufenName = null;
        int n2 = JOptionPane.showConfirmDialog(null, this.i18n.getString("sim_m93"), this.i18n.getString("sim_m93_titel"), 0);
        if (n2 == 0) {
            this.zeigeSterneMitNamen = true;
        }
        if ((n2 = JOptionPane.showConfirmDialog(null, this.i18n.getString("sim_m97"), this.i18n.getString("sim_m97_titel"), 0)) == 0) {
            this.zeigeLeuchtkraftklassen = true;
        }
        if ((n = JOptionPane.showConfirmDialog(null, this.i18n.getString("sim_m94"), this.i18n.getString("sim_m94_titel"), 0)) == 1) {
            Object[] objectArray = this.sternhaufenDAO.getSternhaufenMitSternen("FHD");
            this.sternhaufenName = (String)JOptionPane.showInputDialog(null, this.i18n.getString("sim_m95"), this.i18n.getString("sim_m95_titel"), 3, null, objectArray, objectArray[0]);
        }
    }

    @Override
    public void collectData() throws SQLException {
        this.sterneDtos = new ArrayList<ErgebnisXYDto>();
        this.sterneDtos = this.sternhaufenName == null ? this.fhdDoa.getFHD("") : this.fhdDoa.getFHD(this.sternhaufenName);
        if (this.sterneDtos == null || this.sterneDtos.isEmpty()) {
            JOptionPane.showMessageDialog(null, this.i18n.getString("sim_f4"), this.i18n.getString("db_f4_titel"), 0);
            this.setVisible(false);
        } else {
            this.setBackground(Color.black);
        }
    }

    @Override
    public JPanel createChart() {
        return this;
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui28");
    }

    @Override
    public String getChartKey() {
        return "sim_gui28";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_sterne");
    }

    @Override
    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STERNE_FHD;
    }
}

