/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.sterne;

import com.google.common.io.Files;
import com.google.inject.Inject;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbankkern.api.repos.IObjektnamenRepository;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.GuiDesignerFabrik;
import de.planetensuche.guidesigner.IGuiDesigner;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.ErgebnisXYDto;
import de.planetensuche.simulationen.dbmodel.api.IHRDDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISternhaufenDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.simulationen.diagramme.sterne.LeuchtkraftklassenZeichner;
import de.planetensuche.simulationen.diagramme.util.SptypDoubleKonverter;
import de.planetensuche.simulationen.diagramme.util.SptypFarbKonverter;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class HrdChart
extends JPanel
implements IChart {
    private final ILogging logger;
    private final ISprachcontainer i18n;
    private final IGuiDesigner guiDesigner;
    private final LeuchtkraftklassenZeichner leuchtkraftklassenZeichner;
    private final IHRDDAO hrdDao;
    private final ISternhaufenDAO sternhaufenDAO;
    private final int screenx;
    private final int screeny;
    private final int stepx;
    private final int stepy;
    private boolean zeigeSterneMitNamen;
    private boolean zeigeLeuchtkraftklassen;
    private String sternhaufenName;
    private List<ErgebnisXYDto> sterneDtos;
    private final String[] yLabel = new String[]{"-10", "-5", "0", "5", "10", "15", "20", "25", "30"};
    private final String[] xLabel = new String[]{"O", "B", "A", "F", "G", "K", "M", "L", "T", "Y"};
    private final double absmagNull;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private final IObjektnamenRepository objektnamenRepository;

    @Inject
    public HrdChart(IChartRepository iChartRepository, IHRDDAO iHRDDAO, ISternhaufenDAO iSternhaufenDAO, IPlanetensucheObjektRepository iPlanetensucheObjektRepository, IObjektnamenRepository iObjektnamenRepository) {
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.guiDesigner = GuiDesignerFabrik.getInstance();
        this.hrdDao = iHRDDAO;
        this.sternhaufenDAO = iSternhaufenDAO;
        this.logger = LoggingFactory.getLoggerForClass(HrdChart.class);
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.objektnamenRepository = iObjektnamenRepository;
        this.leuchtkraftklassenZeichner = new LeuchtkraftklassenZeichner(this.i18n);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.screenx = (int)((double)dimension.width * 0.8) - 275;
        this.screeny = (int)((double)dimension.height * 0.8) - 75;
        this.setBounds(0, 0, this.screenx + 275, this.screeny + 75);
        this.setPreferredSize(new Dimension(this.screenx + 275, this.screeny + 75));
        this.stepx = (this.screenx - 70) / this.xLabel.length;
        this.stepy = (this.screeny - 70) / this.yLabel.length;
        this.absmagNull = (double)this.screeny - 50.0 - ((double)this.yLabel.length - 3.0) * (double)this.stepy;
        iChartRepository.register(this);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.sterneDtos.isEmpty()) {
            return;
        }
        SptypFarbKonverter sptypFarbKonverter = new SptypFarbKonverter();
        this.paintLegende(graphics, sptypFarbKonverter);
        if (this.zeigeLeuchtkraftklassen) {
            this.leuchtkraftklassenZeichner.paintLeuchtkraftklassenLegende(graphics, this.screenx);
        }
        this.paintAchsen(graphics);
        this.paintSterneBrauneZwerge(sptypFarbKonverter, graphics);
        if (this.zeigeSterneMitNamen) {
            this.paintSternnamenBeispielsterne(graphics);
        }
        if (this.zeigeLeuchtkraftklassen) {
            this.paintLeuchtkraftklassen(graphics);
        }
    }

    private void paintLegende(Graphics graphics, SptypFarbKonverter sptypFarbKonverter) {
        graphics.setColor(Color.WHITE);
        graphics.setFont(this.guiDesigner.getFont(false));
        graphics.drawString(this.i18n.toLocalisedNumber(this.sterneDtos.size()) + " " + this.i18n.getString("sim_m47"), this.screenx, 25);
        graphics.drawString(this.i18n.getString("sim_gui70"), this.screenx, 75);
        graphics.drawString(this.i18n.getString("sim_gui71"), this.screenx, 100);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("O"));
        graphics.drawString("O - " + this.i18n.getString("sim_gui72") + " (>" + this.i18n.toLocalisedInt(25000) + "K)", this.screenx, 125);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("B"));
        graphics.drawString("B - " + this.i18n.getString("sim_gui73") + " (" + this.i18n.toLocalisedInt(10000) + "-" + this.i18n.toLocalisedInt(25000) + "K)", this.screenx, 150);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("A"));
        graphics.drawString("A - " + this.i18n.getString("sim_gui74") + " (" + this.i18n.toLocalisedInt(7600) + "-" + this.i18n.toLocalisedInt(10000) + "K)", this.screenx, 175);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("F"));
        graphics.drawString("F - " + this.i18n.getString("sim_gui75") + " (" + this.i18n.toLocalisedInt(6000) + "-" + this.i18n.toLocalisedInt(7600) + "K)", this.screenx, 200);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("G"));
        graphics.drawString("G - " + this.i18n.getString("sim_gui76") + " (" + this.i18n.toLocalisedInt(5100) + "-" + this.i18n.toLocalisedInt(6000) + "K)", this.screenx, 225);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("K"));
        graphics.drawString("K - " + this.i18n.getString("sim_gui77") + " (" + this.i18n.toLocalisedInt(3600) + "-" + this.i18n.toLocalisedInt(5100) + "K)", this.screenx, 250);
        graphics.setColor(sptypFarbKonverter.getColorForSptyp("M"));
        graphics.drawString("M - " + this.i18n.getString("sim_gui78") + " (" + this.i18n.toLocalisedInt(2500) + "-" + this.i18n.toLocalisedInt(3600) + "K)", this.screenx, 275);
        graphics.setColor(Color.WHITE);
        graphics.drawString(this.i18n.getString("ps_br_zwerge") + ":", this.screenx, 325);
        graphics.setColor(new Color(255, 0, 0));
        graphics.drawString("L, T, Y - " + this.i18n.getString("sim_gui78") + " (<" + this.i18n.toLocalisedInt(2700) + "K)", this.screenx, 350);
    }

    private void paintAchsen(Graphics graphics) {
        int n;
        graphics.drawLine(50, this.screeny, this.stepx * this.xLabel.length, this.screeny);
        graphics.drawString(this.i18n.getString("sim_gui70"), this.stepx * this.xLabel.length, this.screeny + 25);
        for (n = 0; n < this.xLabel.length; ++n) {
            graphics.drawLine(50 + n * this.stepx, this.screeny, 50 + n * this.stepx, this.screeny + 10);
            graphics.drawString(this.xLabel[n], 50 + n * this.stepx, this.screeny + 25);
        }
        graphics.drawLine(50, 0, 50, this.screeny);
        graphics.drawString(this.i18n.getString("db_m110"), 10, 50);
        graphics.drawString("in mag", 10, 65);
        for (n = this.yLabel.length - 1; n > -1; --n) {
            graphics.drawLine(50, this.screeny - 50 - n * this.stepy, 40, this.screeny - 50 - n * this.stepy);
            int n2 = 20;
            if (this.yLabel[this.yLabel.length - 1 - n].length() == 2) {
                n2 = 25;
            } else if (this.yLabel[this.yLabel.length - 1 - n].length() == 1) {
                n2 = 35;
            }
            graphics.drawString(this.yLabel[this.yLabel.length - 1 - n], n2, this.screeny - 50 - n * this.stepy);
        }
        for (n = this.yLabel.length - 1; n > -1; --n) {
            graphics.drawLine(50, this.screeny - 50 - (n * this.stepy + this.stepy / 2), 45, this.screeny - 50 - (n * this.stepy + this.stepy / 2));
        }
    }

    private void paintSterneBrauneZwerge(SptypFarbKonverter sptypFarbKonverter, Graphics graphics) {
        try {
            for (ErgebnisXYDto ergebnisXYDto : this.sterneDtos) {
                double d = ergebnisXYDto.getY();
                double d2 = ergebnisXYDto.getX();
                if (!(d >= -15.0) || !(d <= 35.0) || !(d2 >= 0.0) || !(d2 <= 100.0)) continue;
                Color color = sptypFarbKonverter.getColorForSptyp(d2);
                graphics.setColor(color);
                d = d > 0.0 ? this.absmagNull + d / 5.0 * (double)this.stepy : (d < 0.0 ? this.absmagNull - d * -1.0 / 5.0 * (double)this.stepy : this.absmagNull);
                d2 = 50.0 + (double)this.stepx * (d2 / 10.0);
                int n = (int)Math.round(d);
                int n2 = (int)Math.round(d2);
                graphics.fillOval(n2, n, 2, 2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.error(numberFormatException);
        }
    }

    private void paintSternnamenBeispielsterne(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        try {
            SptypDoubleKonverter sptypDoubleKonverter = new SptypDoubleKonverter();
            List<String> list = Files.readLines(new File("sterne.txt"), Charset.forName("UTF-8"));
            for (String string : list) {
                try {
                    String[] stringArray;
                    Integer n;
                    if (string.startsWith("//") || (n = this.objektnamenRepository.getIDFuerNamen((stringArray = string.split(","))[0], true)) == null) continue;
                    IPlanetensucheObjekt iPlanetensucheObjekt = this.planetensucheObjektRepository.read(n);
                    char c = iPlanetensucheObjekt.getSpektralklasse().charAt(0);
                    double d = sptypDoubleKonverter.getDoubleForSptyp(c);
                    d += iPlanetensucheObjekt.getSpektralklasse2();
                    double d2 = iPlanetensucheObjekt.getAbsoluteHelligkeit();
                    if (!(d2 >= -15.0) || !(d2 <= 35.0) || !(d >= 0.0) || !(d <= 100.0)) continue;
                    d = 50.0 + (double)this.stepx * (d / 10.0);
                    d2 = d2 > 0.0 ? this.absmagNull + d2 / 5.0 * (double)this.stepy : (d2 < 0.0 ? this.absmagNull - d2 * -1.0 / 5.0 * (double)this.stepy : this.absmagNull);
                    int n2 = (int)Math.round(d2);
                    int n3 = (int)Math.round(d);
                    graphics.drawOval(n3 - 10, n2 - 10, 20, 20);
                    graphics.drawString(stringArray[0], n3 + 10, n2 + 5);
                }
                catch (NumberFormatException | SQLException exception) {
                    this.logger.error(exception);
                }
            }
        }
        catch (IOException iOException) {
            this.zeigeFehlermeldung(iOException);
        }
    }

    private void paintLeuchtkraftklassen(Graphics graphics) {
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        graphics.setColor(Color.WHITE);
        double d6 = 7.3;
        double d7 = 7.4;
        for (d2 = 1.5; d2 < 7.0; d2 += 0.5) {
            d = 50.0 + (d2 - 0.5) * (double)this.stepx;
            d3 = (double)(this.screeny - 50) - d7 * (double)this.stepy;
            d7 = d6;
            d4 = 50.0 + d2 * (double)this.stepx;
            d5 = (double)(this.screeny - 50) - d6 * (double)this.stepy;
            d6 = d2 >= 5.5 ? (d6 += 0.05) : (d6 += 0.012);
            graphics.drawLine((int)d, (int)d3, (int)d4, (int)d5);
        }
        graphics.drawString("Ia", (int)d4 + 10, (int)d3);
        d6 = 7.0;
        d7 = 7.1;
        for (d2 = 1.5; d2 < 7.0; d2 += 0.5) {
            d = 50.0 + (d2 - 0.5) * (double)this.stepx;
            d3 = (double)(this.screeny - 50) - d7 * (double)this.stepy;
            d7 = d6;
            d4 = 50.0 + d2 * (double)this.stepx;
            d5 = (double)(this.screeny - 50) - d6 * (double)this.stepy;
            d6 = d2 >= 5.5 ? (d6 += 0.05) : (d6 += 0.005);
            graphics.drawLine((int)d, (int)d3, (int)d4, (int)d5);
        }
        graphics.drawString("Ib", (int)d4 + 10, (int)d3);
        d6 = 6.75;
        d7 = 6.8;
        for (d2 = 1.5; d2 < 7.0; d2 += 0.5) {
            d = 50.0 + (d2 - 0.5) * (double)this.stepx;
            d3 = (double)(this.screeny - 50) - d7 * (double)this.stepy;
            d7 = d6;
            d4 = 50.0 + d2 * (double)this.stepx;
            d5 = (double)(this.screeny - 50) - d6 * (double)this.stepy;
            d6 = d2 >= 4.0 ? (d6 += 0.05) : (d6 -= 0.05);
            graphics.drawLine((int)d, (int)d3, (int)d4, (int)d5);
        }
        graphics.drawString("II", (int)d4 + 10, (int)d5);
        d6 = 7.1;
        d7 = 7.35;
        for (d2 = 0.5; d2 < 7.0; d2 += 0.25) {
            d = 50.0 + (d2 - 0.25) * (double)this.stepx;
            d3 = (double)(this.screeny - 50) - d7 * (double)this.stepy;
            d7 = d6;
            d4 = 50.0 + d2 * (double)this.stepx;
            d5 = (double)(this.screeny - 50) - d6 * (double)this.stepy;
            d6 = d2 >= 5.5 ? (d6 += 0.1) : (d2 >= 1.25 ? (d6 -= 0.025) : (d6 -= 0.25));
            graphics.drawLine((int)d, (int)d3, (int)d4, (int)d5);
        }
        graphics.drawString("III", (int)d4 + 10, (int)d5);
        d6 = 6.85;
        d7 = 7.1;
        for (d2 = 0.5; d2 < 5.25; d2 += 0.25) {
            d = 50.0 + (d2 - 0.25) * (double)this.stepx;
            d3 = (double)(this.screeny - 50) - d7 * (double)this.stepy;
            d7 = d6;
            d4 = 50.0 + d2 * (double)this.stepx;
            d5 = (double)(this.screeny - 50) - d6 * (double)this.stepy;
            d6 = d2 >= 1.25 ? (d6 -= 0.05) : (d6 -= 0.25);
            graphics.drawLine((int)d, (int)d3, (int)d4, (int)d5);
        }
        graphics.drawString("IV", (int)d4 + 10, (int)d5);
        d6 = 6.75;
        d7 = 7.0;
        for (d2 = 0.5; d2 < 6.5; d2 += 0.25) {
            d = 50.0 + (d2 - 0.25) * (double)this.stepx;
            d3 = (double)(this.screeny - 50) - d7 * (double)this.stepy;
            d7 = d6;
            d4 = 50.0 + d2 * (double)this.stepx;
            d5 = (double)(this.screeny - 50) - d6 * (double)this.stepy;
            d6 = d2 >= 5.5 ? (d6 -= 0.2) : (d2 < 1.25 ? (d6 -= 0.25) : (d6 -= 0.08));
            graphics.drawLine((int)d, (int)d3, (int)d4, (int)d5);
        }
        graphics.drawString("V", (int)d4 + 10, (int)d5);
        d = d4;
        d3 = d5;
        d4 = d + (double)this.stepx * 0.7;
        d5 = d3 + (double)(this.stepy * 2);
        graphics.drawLine((int)d, (int)d3, (int)d4, (int)d5);
        graphics.drawString("VI", (int)d4 + 10, (int)d5);
        d = d4;
        d3 = d5;
        d4 = d + (double)this.stepx * 1.5;
        d5 = d3 + (double)this.stepy * 2.2;
        graphics.drawLine((int)d, (int)d3, (int)d4, (int)d5);
        graphics.drawString("Braune Zwerge", (int)d4 + 10, (int)d5);
        d6 = 4.0;
        d7 = 4.25;
        for (d2 = 0.5; d2 < 5.0; d2 += 0.25) {
            d = 50.0 + (d2 - 0.25) * (double)this.stepx;
            d3 = (double)(this.screeny - 50) - d7 * (double)this.stepy;
            d7 = d6;
            d4 = 50.0 + d2 * (double)this.stepx;
            d5 = (double)(this.screeny - 50) - d6 * (double)this.stepy;
            d6 = d2 <= 2.5 ? (d6 -= 0.075) : (d6 -= 0.05);
            graphics.drawLine((int)d, (int)d3, (int)d4, (int)d5);
        }
        graphics.drawString("VII", (int)d4 + 10, (int)d5);
    }

    private void zeigeFehlermeldung(IOException iOException) {
        this.logger.error(iOException);
        this.logger.showErrorMessageBox(null, this.i18n.getString("sim_f2") + "\n" + iOException.toString(), this.i18n.getString("sim_f2_titel"));
    }

    @Override
    public void beforeCollectData() {
        int n;
        this.zeigeSterneMitNamen = false;
        this.zeigeLeuchtkraftklassen = false;
        this.sternhaufenName = null;
        int n2 = JOptionPane.showConfirmDialog(null, this.i18n.getString("sim_m93"), this.i18n.getString("sim_m93_titel"), 0);
        if (n2 == 0) {
            this.zeigeSterneMitNamen = true;
        }
        if ((n2 = JOptionPane.showConfirmDialog(null, this.i18n.getString("sim_m97"), this.i18n.getString("sim_m97_titel"), 0)) == 0) {
            this.zeigeLeuchtkraftklassen = true;
        }
        if ((n = JOptionPane.showConfirmDialog(null, this.i18n.getString("sim_m94"), this.i18n.getString("sim_m94_titel"), 0)) == 1) {
            Object[] objectArray = this.sternhaufenDAO.getSternhaufenMitSternen("HRD");
            this.sternhaufenName = (String)JOptionPane.showInputDialog(null, this.i18n.getString("sim_m95"), this.i18n.getString("sim_m95_titel"), 3, null, objectArray, objectArray[0]);
        }
    }

    @Override
    public void collectData() throws SQLException {
        this.sterneDtos = new ArrayList<ErgebnisXYDto>();
        this.sterneDtos = this.sternhaufenName == null ? this.hrdDao.getHRD("") : this.hrdDao.getHRD(this.sternhaufenName);
        if (this.sterneDtos == null || this.sterneDtos.isEmpty()) {
            JOptionPane.showMessageDialog(null, this.i18n.getString("sim_f4"), this.i18n.getString("db_f4_titel"), 0);
            this.setVisible(false);
        } else {
            this.setBackground(Color.black);
        }
    }

    @Override
    public JPanel createChart() {
        return this;
    }

    @Override
    public String getChartName() {
        return this.i18n.getString("sim_gui27");
    }

    @Override
    public String getChartKey() {
        return "sim_gui27";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_sterne");
    }

    @Override
    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STERNE_HRD;
    }
}

