/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.sterne;

import com.google.inject.Inject;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.apache.commons.lang3.tuple.Pair;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeriesCollection;

public final class MassAndDiameterForEachLuminClassChart
implements IChart {
    private final ISprachcontainer sprache;
    private final DiagrammHelfer helfer;
    private final ISterneDAO sterneDAO;
    private final IDatenbankService datenbankService;
    private XYSeriesCollection collection;
    private double maxMsun;

    @Inject
    public MassAndDiameterForEachLuminClassChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO) {
        this.sterneDAO = iSterneDAO;
        this.datenbankService = BeanFactory.getInstance();
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.sprache);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
        this.maxMsun = this.helfer.zeigeEingabeDialog(null, this.sprache.getString("sim_m12"), this.sprache.getString("sim_m10"), 5.0, "Dsun/Msun", 0.01, new double[0]);
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        Map<String, List<Pair<Double, Double>>> map = this.sterneDAO.getMasseUndDurchmesser(this.maxMsun);
        for (Map.Entry<String, List<Pair<Double, Double>>> entry : map.entrySet()) {
            this.helfer.fuelleCollection(this.collection, this.sprache.getString("sim_m26") + " " + entry.getKey(), entry.getValue());
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("sim_m70"), this.sprache.getString("sim_m73"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui82");
    }

    @Override
    public String getChartKey() {
        return "sim_gui82";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_sterne");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STERNE_MASSE_DURCHMESSER_LV;
    }
}

