/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.sterne;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DatasetUtils;

public final class NumberOfStarsAndBrightnessChart
implements IChart {
    private final ISprachcontainer i18n;
    private final ISterneDAO sterneDAO;
    private DefaultCategoryDataset dataset;
    private DefaultKeyedValues dataForKumulativView;

    @Inject
    public NumberOfStarsAndBrightnessChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO) {
        this.sterneDAO = iSterneDAO;
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        long l = 0L;
        this.dataset = new DefaultCategoryDataset();
        this.dataForKumulativView = new DefaultKeyedValues();
        for (double d = 4.0; d < 11.0; d += 1.0) {
            double d2 = d == 4.0 ? -2.0 : d - 1.0;
            double d3 = d;
            long l2 = this.sterneDAO.getNumberOfStarsPerBrightness(d2, d3);
            this.dataset.addValue(l2, (Comparable)((Object)this.i18n.getString("sim_gui151")), (Comparable)((Object)this.i18n.toLocalisedDouble(d)));
            this.dataForKumulativView.addValue(this.i18n.toLocalisedDouble(d), l += l2);
        }
    }

    @Override
    public JPanel createChart() {
        CategoryDataset categoryDataset = DatasetUtils.createCategoryDataset((Comparable)((Object)this.i18n.getString("sim_gui111")), this.dataForKumulativView);
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.i18n.getString("sim_gui150"), this.i18n.getString("sim_m69"), this.i18n.getString("sim_gui151"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        categoryPlot.setDataset(1, categoryDataset);
        categoryPlot.setRenderer(1, lineAndShapeRenderer);
        categoryPlot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.i18n.getString(this.getChartKey());
    }

    @Override
    public String getChartKey() {
        return "sim_gui150";
    }

    @Override
    public String getCategoryName() {
        return this.i18n.getString("ps_sterne");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STERNE_ANZAHL_STERNE_VMAG;
    }
}

