/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.sterne;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeriesCollection;

public final class RadialVelocityAndMetallicityChart
implements IChart {
    private final String restlicheSterneKey = "sim_m25";
    private final String sterneMitExoplanetenKey = "sim_m24";
    private final ISprachcontainer sprache;
    private final DiagrammHelfer helfer;
    private final ISterneDAO sterneDAO;
    private XYSeriesCollection collection;

    @Inject
    public RadialVelocityAndMetallicityChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO) {
        this.sterneDAO = iSterneDAO;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.sprache);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        this.helfer.fuelleCollection(this.collection, this.sprache.getString("sim_m24"), this.sterneDAO.getRadialUndMetal(true));
        this.helfer.fuelleCollection(this.collection, this.sprache.getString("sim_m25"), this.sterneDAO.getRadialUndMetal(false));
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("db_m236"), this.sprache.getString("sim_m124"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui99");
    }

    @Override
    public String getChartKey() {
        return "sim_gui99";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_sterne");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STERNE_RV_METALIZITAET;
    }
}

