/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.sterne;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.IDurchschnittsSternDAO;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISterneDAO;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public final class StarAgeAndSptypChart
implements IChart {
    private final ISprachcontainer sprache;
    private final ISterneDAO sterneDAO;
    private final IDatenbankService datenbankService;
    private final IDurchschnittsSternDAO durchschnittsSternDAO;
    private DefaultCategoryDataset dataset;

    @Inject
    public StarAgeAndSptypChart(IChartRepository iChartRepository, ISterneDAO iSterneDAO, IDurchschnittsSternDAO iDurchschnittsSternDAO) {
        this.sterneDAO = iSterneDAO;
        this.durchschnittsSternDAO = iDurchschnittsSternDAO;
        this.datenbankService = BeanFactory.getInstance();
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.dataset = new DefaultCategoryDataset();
        List<String> list = this.datenbankService.getObjekttypen(ObjektKategorie.STERNE.getKategorienName());
        for (int i = 0; i < list.size(); ++i) {
            double d = this.sterneDAO.getHoehstAlter(list.get(i));
            if (!(d > 0.0)) continue;
            String string = this.sprache.getUebersetzungFuerAktuelleSprache(list.get(i));
            this.dataset.addValue(d, (Comparable)((Object)string), (Comparable)((Object)this.sprache.getString("sim_m52")));
            this.dataset.addValue(this.durchschnittsSternDAO.getDurchschnittsAlter(list.get(i)), (Comparable)((Object)string), (Comparable)((Object)this.sprache.getString("sim_m53")));
        }
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createBarChart(this.getChartName(), this.sprache.getString("sim_m55"), this.sprache.getString("sim_m86"), this.dataset, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui47");
    }

    @Override
    public String getChartKey() {
        return "sim_gui47";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_sterne");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STERNE_ALTER_SPTYP;
    }
}

