/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.sterne;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.api.IDAOlowAllgemein;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeriesCollection;

public final class TemperaturAndBrightnessChart
implements IChart {
    private final String restlicheSterneKey = "sim_m25";
    private final String sterneMitExoplanetenKey = "sim_m24";
    private final ISprachcontainer sprache;
    private final DiagrammHelfer helfer;
    private final IDAOlowAllgemein daoLowAllgemein;
    private XYSeriesCollection collection;

    @Inject
    public TemperaturAndBrightnessChart(IChartRepository iChartRepository, IDAOlowAllgemein iDAOlowAllgemein) {
        this.daoLowAllgemein = iDAOlowAllgemein;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.sprache);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        this.helfer.fuelleCollection(this.collection, this.sprache.getString("sim_m24"), this.daoLowAllgemein.getTemperaturUndHelligkeit(true, ObjektKategorie.STERNE.getKategorienName()));
        this.helfer.fuelleCollection(this.collection, this.sprache.getString("sim_m25"), this.daoLowAllgemein.getTemperaturUndHelligkeit(false, ObjektKategorie.STERNE.getKategorienName()));
        this.helfer.fuelleCollection(this.collection, this.sprache.getString("ps_br_zwerge"), this.daoLowAllgemein.getTemperaturUndHelligkeit(false, ObjektKategorie.BR_ZWERGE.getKategorienName()));
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("db_m231"), this.sprache.getString("sim_m71"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui40");
    }

    @Override
    public String getChartKey() {
        return "sim_gui40";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_sterne");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STERNE_TEMPERATUR_VMAG;
    }
}

