/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.sternhaufen;

import com.google.inject.Inject;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.simulationen.dbmodel.kategorien.api.ISternhaufenDAO;
import de.planetensuche.simulationen.diagramme.DiagrammHelfer;
import de.planetensuche.simulationen.diagramme.IChart;
import de.planetensuche.simulationen.diagramme.IChartRepository;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeriesCollection;

public final class BVAndAbsoluteBrightnessChart
implements IChart {
    private final ISprachcontainer sprache;
    private final ISternhaufenDAO sternhaufenDAO;
    private DiagrammHelfer helfer;
    private XYSeriesCollection collection;

    @Inject
    public BVAndAbsoluteBrightnessChart(IChartRepository iChartRepository, ISternhaufenDAO iSternhaufenDAO) {
        this.sternhaufenDAO = iSternhaufenDAO;
        this.sprache = SprachcontainerFabrik.getSprachcontainer();
        this.helfer = new DiagrammHelfer(this.sprache);
        iChartRepository.register(this);
    }

    @Override
    public void beforeCollectData() {
    }

    @Override
    public void collectData() throws SQLException {
        this.collection = new XYSeriesCollection();
        this.helfer.fuelleCollection(this.collection, this.sprache.getString("sim_m126"), this.sternhaufenDAO.getBVundAHSternhaufen(false));
        this.helfer.fuelleCollection(this.collection, this.sprache.getString("sim_m125"), this.sternhaufenDAO.getBVundAHSternhaufen(true));
    }

    @Override
    public JPanel createChart() {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot(this.getChartName(), this.sprache.getString("db_m412"), this.sprache.getString("db_m110"), this.collection, PlotOrientation.VERTICAL, true, true, false);
        return new ChartPanel(jFreeChart);
    }

    @Override
    public String getChartName() {
        return this.sprache.getString("sim_gui96");
    }

    @Override
    public String getChartKey() {
        return "sim_gui96";
    }

    @Override
    public String getCategoryName() {
        return this.sprache.getString("ps_sternhaufen");
    }

    public String toString() {
        return this.getChartName();
    }

    @Override
    public BasisdialogId getBasisdialogId() {
        return BasisdialogId.SIMULATION_DIAGRAMM_STERNHAUFEN_BV_AH;
    }
}

