/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diagramme.util;

public final class ExoplanetRadiusCalculator {
    private final double earthMassInGramm = 5.9722 * Math.pow(10.0, 27.0);
    private final double earthRadiusInCm = 6378.0 * Math.pow(10.0, 5.0);
    private double density = 4.5;

    public double calcRadius(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = d * this.earthMassInGramm / this.density;
        double d3 = d2 / 4.1887902047863905;
        double d4 = Math.pow(d3, 0.3333333333333333);
        double d5 = d4 / this.earthRadiusInCm;
        return d5;
    }

    public void setDensity(double d) {
        this.density = d;
    }

    public double getDensity() {
        return this.density;
    }
}

