/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diameter;

import com.google.inject.Injector;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import de.planetensuche.simulationen.diameter.DiameterRepository;
import de.planetensuche.simulationen.diameter.PlanetCompareDto;
import de.planetensuche.simulationen.diameter.PlanetComparisionGui;
import de.planetensuche.simulationen.diameter.StarComparisionGui;
import de.planetensuche.simulationen.diameter.StarDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;

public final class CompareDiameterController {
    private final ILogging logger;
    private final DiameterRepository repository;

    public CompareDiameterController(Injector injector) {
        this.repository = new DiameterRepository(injector.getInstance(IIdCacheDAO.class), injector.getInstance(IDatenbankverbinder.class), injector.getInstance(IDatenbankService.class), injector.getInstance(ISternbilderRepository.class));
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
    }

    public void showStarComparison(JFrame jFrame) {
        new AsyncLoadingScreenCallbackExecutor().execute(jFrame, () -> {
            try {
                Collection<StarDto> collection = this.repository.findStarsOrderedByDiameter();
                new StarComparisionGui(collection).setVisible(true);
            }
            catch (Exception exception) {
                this.logger.error(exception);
            }
        });
    }

    public void showPlanetComparison(JFrame jFrame) {
        new AsyncLoadingScreenCallbackExecutor().execute(jFrame, () -> {
            try {
                Collection<PlanetCompareDto> collection = this.repository.findPlanetsComparisionOrderedByDiameter();
                ArrayList<PlanetCompareDto> arrayList = new ArrayList<PlanetCompareDto>();
                arrayList.addAll(collection);
                Collections.sort(arrayList, (planetCompareDto, planetCompareDto2) -> Double.compare(planetCompareDto.getDiameterInDJup(), planetCompareDto2.getDiameterInDJup()));
                new PlanetComparisionGui(arrayList).setVisible(true);
            }
            catch (Exception exception) {
                this.logger.error(exception);
            }
        });
    }
}

