/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.simulationen.diameter;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.datamodel.api.ISternbild;
import de.planetensuche.datamodel.impl.Sternbild;
import de.planetensuche.datamodel.impl.SternbildFinder;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.datenbankkern.querydsl5.QNamen;
import de.planetensuche.datenbankkern.querydsl5.QSpektraltyp;
import de.planetensuche.datenbankkern.querydsl5.QZt;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.simulationen.diameter.ObjectType;
import de.planetensuche.simulationen.diameter.PlanetCompareDto;
import de.planetensuche.simulationen.diameter.StarDto;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class DiameterRepository {
    private final ILogging logger;
    private final IIdCacheDAO idCache;
    private final IDatenbankverbinder dbVerbinder;
    private final IDatenbankService datenbankService;
    private final ISternbilderRepository sternbilderRepository;

    public DiameterRepository(IIdCacheDAO iIdCacheDAO, IDatenbankverbinder iDatenbankverbinder, IDatenbankService iDatenbankService, ISternbilderRepository iSternbilderRepository) {
        this.idCache = iIdCacheDAO;
        this.dbVerbinder = iDatenbankverbinder;
        this.datenbankService = iDatenbankService;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
        this.sternbilderRepository = iSternbilderRepository;
    }

    public Collection<PlanetCompareDto> findPlanetsComparisionOrderedByDiameter() throws IOException {
        LinkedHashMap<Integer, PlanetCompareDto> linkedHashMap = new LinkedHashMap<Integer, PlanetCompareDto>();
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.dbVerbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qNamen)).leftJoin((EntityPath)qDaten)).on((Predicate)qNamen.datenid.eq(qDaten.id).and(qNamen.iseigenname.isTrue()))).where(qNamen.iseigenname.isTrue().and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten())))).fetch();
        List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.dbVerbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.durchmesser, qDaten.masse, qDaten.temperatur, qDaten.objektid, qNamen.namen}).from((Expression<?>)qDaten)).join((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qNamen.namen.in(list).and(qDaten.durchmesser.gt(0.0)).or(qDaten.durchmesser.gt(0.0).and(qDaten.masse.gt(0.0)).and(qDaten.temperatur.between(-273.0, 500))).or(qDaten.durchmesser.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.durchmesser.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten())))).or(qDaten.durchmesser.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.durchmesser.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsPlaneten()).and(qDaten.durchmesser.gt(0.0)))))).and(qDaten.entdeckungbestaetigt.isTrue()).or(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.durchmesser.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.durchmesser.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.durchmesser.gt(0.0)))))).or(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.durchmesser.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.durchmesser.min()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsBraunezwerge()).and(qDaten.durchmesser.gt(7.0)))))).or(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsMonde()).and(qDaten.durchmesser.eq((Expression)((SQLQuery)SQLExpressions.select(qDaten.durchmesser.max()).from((Expression<?>)qDaten)).where(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsMonde()))))))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{qDaten.durchmesser.asc(), qNamen.namen.asc()})).fetch();
        for (Tuple tuple : list2) {
            PlanetCompareDto planetCompareDto;
            int n = tuple.get(qDaten.id);
            String string = tuple.get(qNamen.namen);
            double d = tuple.get(qDaten.durchmesser);
            Double d2 = tuple.get(qDaten.masse);
            Double d3 = tuple.get(qDaten.temperatur);
            if (d2 != null && d2 == 0.0) {
                d2 = null;
            }
            if (d3 != null && d3 == 273.15) {
                d3 = null;
            }
            Integer n2 = tuple.get(qDaten.objektid);
            if (this.idCache.getObjekttypenidsBraunezwerge().contains(n2)) {
                this.logger.debug("brauner zwerg entdeckt: " + string);
                planetCompareDto = new PlanetCompareDto(string, d, d2, d3, ObjectType.BROWN_DWARF);
            } else if (this.idCache.getObjekttypenidsMonde().contains(n2)) {
                this.logger.debug("mond entdeckt: " + string);
                d /= 142984.0;
                if (d2 != null) {
                    d2 = d2 / 1.898E27;
                }
                planetCompareDto = new PlanetCompareDto(string, d, d2, d3, ObjectType.MOON);
            } else {
                planetCompareDto = new PlanetCompareDto(string, d, d2, d3, ObjectType.PLANET);
            }
            linkedHashMap.put(n, planetCompareDto);
        }
        return linkedHashMap.values();
    }

    public Collection<StarDto> findStarsOrderedByDiameter() throws IOException, SQLException {
        SternbildFinder sternbildFinder = new SternbildFinder();
        QDaten qDaten = QDaten.daten;
        QNamen qNamen = QNamen.namen1;
        QSpektraltyp qSpektraltyp = QSpektraltyp.spektraltyp;
        QZt qZt = QZt.zt;
        List list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.dbVerbinder.getQueryFactory().select((Expression)qNamen.namen).from((Expression<?>)qNamen)).leftJoin((EntityPath)qDaten)).on((Predicate)qNamen.datenid.eq(qDaten.id).and(qNamen.iseigenname.isTrue()))).where(qNamen.iseigenname.isTrue().and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())))).fetch();
        List list2 = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.dbVerbinder.getQueryFactory().select(new Expression[]{qDaten.id, qDaten.durchmesser, qDaten.ra, qDaten.decl, qSpektraltyp.typ, qNamen.namen, qZt.sternbildid}).from((Expression<?>)qDaten)).leftJoin((EntityPath)qNamen)).on((Predicate)qDaten.id.eq(qNamen.datenid))).join((EntityPath)qSpektraltyp)).on((Predicate)qDaten.spektralklasse.eq(qSpektraltyp.id))).leftJoin((EntityPath)qZt)).on((Predicate)qZt.datenid.eq(qDaten.id))).where(qNamen.namen.in(list).and(qDaten.spektralklasse.isNotNull()).and(qDaten.durchmesser.gt(0.0)).and(qSpektraltyp.typ.ne("unbekannt")).or(qDaten.durchmesser.goe(100.0).and(qDaten.objektid.in((Collection<Integer>)this.idCache.getObjekttypenidsSterne())).and(qDaten.spektralklasse.isNotNull()).and(qSpektraltyp.typ.ne("unbekannt"))))).orderBy((OrderSpecifier<?>[])new OrderSpecifier[]{qDaten.durchmesser.asc(), qNamen.namen.asc()})).fetch();
        this.logger.debug(list2.size() + " sterne mit durchmesser gefunden");
        List<ISternbild> list3 = this.sternbilderRepository.findAll();
        Map<Integer, ISternbild> map = list3.stream().collect(Collectors.toMap(iSternbild -> iSternbild.getId(), iSternbild -> iSternbild));
        double d = 0.01;
        boolean bl = true;
        LinkedHashMap<Integer, StarDto> linkedHashMap = new LinkedHashMap<Integer, StarDto>();
        for (Tuple tuple : list2) {
            String string = tuple.get(qNamen.namen);
            double d2 = tuple.get(qDaten.durchmesser);
            if (d2 > d) {
                bl = true;
                d *= 1.3;
            }
            if (!bl) continue;
            bl = false;
            StarDto starDto = new StarDto(string, d2, tuple.get(qSpektraltyp.typ));
            Integer n = tuple.get(qZt.sternbildid);
            if (n == null) {
                Double d3 = tuple.get(qDaten.ra);
                Double d4 = tuple.get(qDaten.decl);
                String string2 = sternbildFinder.getSternbildCodeFuerKoordinate(d3, d4);
                Sternbild sternbild = new Sternbild();
                this.datenbankService.getAllDataSternbild(sternbild, string2);
                starDto.setConstellation(this.getSternbildNameFuerAktuelleSprache(sternbild));
            } else {
                starDto.setConstellation(this.getSternbildNameFuerAktuelleSprache(map.get(n)));
            }
            linkedHashMap.put(tuple.get(qDaten.id), starDto);
        }
        this.logger.debug("sterne mit durchmesser auf " + linkedHashMap.size() + " sterne reduziert");
        return linkedHashMap.values();
    }

    private String getSternbildNameFuerAktuelleSprache(ISternbild iSternbild) {
        if (SprachcontainerFabrik.getSprachcontainer().isAktuelleSpracheDeutsch()) {
            return iSternbild.getSternbildDTBezeichnung();
        }
        return iSternbild.getSternbildENGBezeichnung();
    }
}

